/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.registry.Registries;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.conditions.ConditionCodec;
import net.minecraftforge.common.crafting.conditions.ICondition;

public final class ConditionalRecipeSerializer
implements RecipeSerializer<Recipe<?>> {
    public static final RecipeType<DummyRecipe> DUMMY_RECIPE_TYPE = RecipeType.simple((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"supermartijn642corelib", (String)"dummy"));
    public static final Recipe<?> DUMMY_RECIPE = new DummyRecipe();
    public static final ConditionalRecipeSerializer INSTANCE = new ConditionalRecipeSerializer();
    private static final MapCodec<Recipe<?>> CODEC = new MapCodec<Recipe<?>>(){

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.empty();
        }

        public <T> DataResult<Recipe<?>> decode(DynamicOps<T> ops, MapLike<T> input) {
            JsonObject json = new JsonObject();
            input.entries().map(entry -> {
                DataResult key = ops.getStringValue(entry.getFirst());
                return key.isSuccess() ? Pair.of((Object)((String)key.getOrThrow()), (Object)entry.getSecond()) : null;
            }).filter(Objects::nonNull).forEach(entry -> json.add((String)entry.getFirst(), (JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, entry.getSecond())));
            JsonElement recipeJson = ConditionalRecipeSerializer.unwrapRecipe(null, json, ops);
            if (recipeJson == null) {
                return DataResult.success(DUMMY_RECIPE);
            }
            Object t = JsonOps.INSTANCE.convertTo(ops, recipeJson);
            return Recipe.CODEC.parse(ops, t);
        }

        public <T> RecordBuilder<T> encode(Recipe<?> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return (RecordBuilder)Recipe.CODEC.encodeStart(ops, input).flatMap(output -> {
                JsonElement element = (JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, output);
                if (element.isJsonObject()) {
                    RecordBuilder map = ops.mapBuilder();
                    for (String key : element.getAsJsonObject().keySet()) {
                        map.add(key, JsonOps.INSTANCE.convertTo(ops, element.getAsJsonObject().get(key)));
                    }
                    return DataResult.success((Object)map);
                }
                return DataResult.error(() -> "Expected object but got " + String.valueOf(element) + " from recipe codec!");
            }).getOrThrow();
        }
    };

    public static JsonObject wrapRecipeWithForgeConditions(JsonObject recipe, Collection<ICondition> conditions) {
        JsonObject json = new JsonObject();
        json.addProperty("type", Registries.RECIPE_SERIALIZERS.getIdentifier(INSTANCE).toString());
        JsonArray conditionsJson = new JsonArray();
        for (ICondition condition : conditions) {
            conditionsJson.add((JsonElement)ICondition.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)condition).getOrThrow());
        }
        json.add("conditions", (JsonElement)conditionsJson);
        json.add("recipe", (JsonElement)recipe);
        return json;
    }

    public static JsonObject wrapRecipe(JsonObject recipe, Collection<ResourceCondition> conditions) {
        return ConditionalRecipeSerializer.wrapRecipeWithForgeConditions(recipe, conditions.stream().map(ResourceCondition::createForgeCondition).collect(Collectors.toList()));
    }

    private ConditionalRecipeSerializer() {
    }

    public static <T> JsonElement unwrapRecipe(ResourceLocation location, JsonObject json, DynamicOps<T> ops) {
        if (!json.has("conditions") || !json.get("conditions").isJsonArray()) {
            throw new RuntimeException("Conditional recipe '" + String.valueOf(location) + "' must have 'conditions' array!");
        }
        if (!json.has("recipe") || !json.get("recipe").isJsonObject()) {
            throw new RuntimeException("Conditional recipe '" + String.valueOf(location) + "' must have 'recipe' object!");
        }
        ICondition.IContext context = ConditionCodec.getContext(ops);
        JsonArray conditions = json.getAsJsonArray("conditions");
        for (JsonElement conditionElement : conditions) {
            ICondition condition;
            try {
                Object t = JsonOps.INSTANCE.convertTo(ops, conditionElement);
                condition = (ICondition)((Pair)ICondition.CODEC.decode(ops, t).getOrThrow()).getFirst();
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered exception whilst testing conditions for recipe '" + String.valueOf(location) + "'!", e);
            }
            if (condition.test(context, ops)) continue;
            return null;
        }
        return json.getAsJsonObject("recipe");
    }

    public MapCodec<Recipe<?>> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, Recipe<?>> streamCodec() {
        return StreamCodec.unit(null);
    }

    private static class DummyRecipe
    implements Recipe<RecipeInput> {
        private DummyRecipe() {
        }

        public boolean matches(RecipeInput container, Level level) {
            return false;
        }

        public ItemStack assemble(RecipeInput container, HolderLookup.Provider provider) {
            return ItemStack.EMPTY;
        }

        public RecipeSerializer<DummyRecipe> getSerializer() {
            return null;
        }

        public RecipeType<DummyRecipe> getType() {
            return DUMMY_RECIPE_TYPE;
        }

        public PlacementInfo placementInfo() {
            return PlacementInfo.NOT_PLACEABLE;
        }

        public RecipeBookCategory recipeBookCategory() {
            return RecipeBookCategories.CRAFTING_MISC;
        }
    }
}

