/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.theme;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.screens.JmUILegacy;
import journeymap.client.ui.theme.IThemeToolbarInternal;
import journeymap.client.ui.theme.Theme;
import journeymap.client.ui.theme.ThemeButton;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ThemeToolbar
extends Button
implements IThemeToolbarInternal {
    private final ButtonList buttonList;
    private Theme theme;
    private Theme.Container.Toolbar.ToolbarSpec toolbarSpec;
    private ResourceLocation textureBegin;
    private ResourceLocation textureInner;
    private ResourceLocation textureEnd;

    public ThemeToolbar(Theme theme, Button ... buttons) {
        this(theme, new ButtonList(buttons));
    }

    public ThemeToolbar(Theme theme, ThemeButton ... buttons) {
        this(theme, new ButtonList(buttons));
    }

    public ThemeToolbar(Theme theme, ButtonList buttonList) {
        super(buttonList.getWidth(), buttonList.getHeight(), "", ThemeToolbar.emptyPressable());
        this.buttonList = buttonList;
        this.updateTheme(theme);
    }

    public void updateTheme(Theme theme) {
        this.theme = theme;
        this.updateTextures();
    }

    public Theme.Container.Toolbar.ToolbarSpec updateTextures() {
        Theme.Container.Toolbar.ToolbarSpec toolbarSpec = this.buttonList.isHorizontal() ? this.theme.container.toolbar.horizontal : this.theme.container.toolbar.vertical;
        this.setWidth(this.buttonList.getWidth());
        this.setHeight(this.buttonList.getHeight());
        if (this.toolbarSpec == null || toolbarSpec != this.toolbarSpec) {
            this.toolbarSpec = toolbarSpec;
            if (toolbarSpec.useThemeImages) {
                String pathPattern = "container/" + toolbarSpec.prefix + "toolbar_%s.png";
                this.textureBegin = TextureCache.getThemeTexture(this.theme, String.format(pathPattern, "begin"));
                this.textureInner = TextureCache.getThemeTexture(this.theme, String.format(pathPattern, "inner"));
                this.textureEnd = TextureCache.getThemeTexture(this.theme, String.format(pathPattern, "end"));
            }
        }
        return this.toolbarSpec;
    }

    public void updateLayout() {
        this.updateTextures();
        int drawX = this.buttonList.getLeftX() - 1;
        int drawY = this.buttonList.getTopY() - 1;
        this.setScrollablePosition(drawX, drawY);
    }

    public Theme.Container.Toolbar.ToolbarSpec getToolbarSpec() {
        return this.toolbarSpec;
    }

    private ButtonList getButtonList() {
        return this.buttonList;
    }

    public boolean contains(net.minecraft.client.gui.components.Button button) {
        return this.buttonList.contains(button);
    }

    public <B extends Button> void add(B ... buttons) {
        this.buttonList.addAll(Arrays.asList(buttons));
    }

    public int getVMargin() {
        if (this.buttonList.isHorizontal()) {
            int heightDiff = (this.buttonList.getHeight() - this.theme.control.button.height) / 2;
            return heightDiff + this.toolbarSpec.margin;
        }
        return this.toolbarSpec.margin;
    }

    public int getHMargin() {
        if (this.buttonList.isHorizontal()) {
            return this.toolbarSpec.begin.width + this.toolbarSpec.margin;
        }
        int widthDiff = (this.buttonList.getWidth() - this.theme.control.button.width) / 2;
        return widthDiff + this.toolbarSpec.margin;
    }

    public void setDrawToolbar(boolean draw) {
        super.setDrawButton(draw);
        for (Button button : this.buttonList) {
            button.setDrawButton(draw);
        }
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float f) {
        if (!this.visible) {
            return;
        }
        double drawX = this.getX();
        double drawY = this.getY();
        if (!this.toolbarSpec.useThemeImages) {
            return;
        }
        PoseStack pose = new PoseStack();
        double endX = drawX + (double)this.buttonList.getWidth();
        double endY = drawY + (double)this.buttonList.getHeight();
        if (this.visible) {
            DrawUtil.drawTexture(graphics, this.textureBegin, this.toolbarSpec.begin.getColor(), this.toolbarSpec.begin.alpha, this.buttonList.isHorizontal() ? drawX - 7.0 : drawX, this.buttonList.isHorizontal() ? drawY : drawY - 7.0, this.buttonList.isHorizontal() ? (double)this.toolbarSpec.begin.width : (double)(this.buttonList.getWidth() + 3), this.buttonList.isHorizontal() ? (double)(this.buttonList.getHeight() + 3) : (double)this.toolbarSpec.begin.height, false, 0.0);
            DrawUtil.drawTexture(graphics, this.textureEnd, this.toolbarSpec.end.getColor(), this.toolbarSpec.end.alpha, this.buttonList.isHorizontal() ? endX : drawX, this.buttonList.isHorizontal() ? drawY : endY, this.buttonList.isHorizontal() ? (double)this.toolbarSpec.end.width : (double)(this.buttonList.getWidth() + 3), this.buttonList.isHorizontal() ? (double)(this.buttonList.getHeight() + 3) : (double)this.toolbarSpec.end.height, false, 0.0);
            DrawUtil.drawTexture(graphics, this.textureInner, this.toolbarSpec.inner.getColor(), this.toolbarSpec.inner.alpha, drawX, drawY, this.buttonList.getWidth() + 3, (double)(this.buttonList.getHeight() + 3), false, 0.0);
        }
    }

    @Override
    public int getCenterX() {
        return super.getX() + this.width / 2;
    }

    @Override
    public int getMiddleY() {
        return super.getY() + this.height / 2;
    }

    @Override
    public int getBottomY() {
        return super.getY() + this.height;
    }

    @Override
    public int getRightX() {
        return super.getX() + this.width;
    }

    @Override
    public List<FormattedCharSequence> getWrappedTooltip() {
        return null;
    }

    public void equalizeWidths(Font fr) {
        this.buttonList.equalizeWidths(fr);
    }

    public void equalizeWidths(Font fr, int hgap, int maxTotalWidth) {
        this.buttonList.equalizeWidths(fr, hgap, maxTotalWidth);
    }

    public ButtonList layoutHorizontal(int startX, int y, boolean leftToRight, int hgap) {
        return this.layoutHorizontal(startX, y, leftToRight, hgap, false);
    }

    public ButtonList layoutHorizontal(int startX, int y, boolean leftToRight, int hgap, boolean alignCenter) {
        this.buttonList.layoutHorizontal(startX, y, leftToRight, hgap, alignCenter);
        this.updateLayout();
        return this.buttonList;
    }

    public ButtonList layoutCenteredVertical(int x, int centerY, boolean leftToRight, int vgap) {
        this.buttonList.layoutCenteredVertical(x, centerY, leftToRight, vgap);
        this.updateLayout();
        return this.buttonList;
    }

    public ButtonList layoutVertical(int x, int startY, boolean leftToRight, int vgap) {
        this.buttonList.layoutVertical(x, startY, leftToRight, vgap);
        this.updateLayout();
        return this.buttonList;
    }

    public ButtonList layoutCenteredHorizontal(int centerX, int y, boolean leftToRight, int hgap) {
        this.buttonList.layoutCenteredHorizontal(centerX, y, leftToRight, hgap);
        this.updateLayout();
        return this.buttonList;
    }

    public ButtonList layoutDistributedHorizontal(int leftX, int y, int rightX, boolean leftToRight) {
        this.buttonList.layoutDistributedHorizontal(leftX, y, rightX, leftToRight);
        this.updateLayout();
        return this.buttonList;
    }

    public ButtonList layoutFilledHorizontal(Font fr, int leftX, int y, int rightX, int hgap, boolean leftToRight) {
        this.buttonList.layoutFilledHorizontal(fr, leftX, y, rightX, hgap, leftToRight);
        this.updateLayout();
        return this.buttonList;
    }

    public void setLayout(ButtonList.Layout layout, ButtonList.Direction direction) {
        this.buttonList.setLayout(layout, direction);
        this.updateLayout();
    }

    public ButtonList reverse() {
        this.buttonList.reverse();
        this.updateLayout();
        return this.buttonList;
    }

    public void addAllButtons(JmUILegacy gui) {
        gui.getButtonList().add(this);
        gui.getButtonList().addAll(this.buttonList);
    }

    public void setReverse() {
        this.reverse();
    }

    public void setLayoutHorizontal(int startX, int y, int hgap, boolean leftToRight) {
        this.layoutHorizontal(startX, y, leftToRight, hgap);
    }

    public void setLayoutCenteredVertical(int x, int centerY, int vgap, boolean leftToRight) {
        this.layoutCenteredVertical(x, centerY, leftToRight, vgap);
    }

    public void setLayoutVertical(int x, int startY, int vgap, boolean leftToRight) {
        this.layoutVertical(x, startY, leftToRight, vgap);
    }

    public void setLayoutCenteredHorizontal(int centerX, int y, int hgap, boolean leftToRight) {
        this.layoutCenteredHorizontal(centerX, y, leftToRight, hgap);
    }

    public void setLayoutDistributedHorizontal(int leftX, int y, int rightX, boolean leftToRight) {
        this.layoutDistributedHorizontal(leftX, y, rightX, leftToRight);
    }

    @Override
    public int getToolbarHeight() {
        return this.getHeight();
    }

    @Override
    public int getToolbarWidth() {
        return this.getWidth();
    }

    @Override
    public int getToolbarX() {
        return this.getX();
    }

    @Override
    public int getToolbarY() {
        return this.getY();
    }

    @Override
    public void setPosition(int i, int j) {
        super.setPosition(i, j);
    }

    @Override
    public void setToolbarPosition(int x, int y) {
        this.setPosition(x, y);
    }
}

