/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.theme;

import java.awt.geom.Rectangle2D;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.minimap.DisplayVars;
import journeymap.client.ui.minimap.ReticleOrientation;
import journeymap.client.ui.theme.Theme;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;

public class ThemeMinimapFrame {
    public final Theme theme;
    public final Theme.Minimap.MinimapSpec minimapSpec;
    private final ReticleOrientation reticleOrientation;
    private final String resourcePattern;
    private ResourceLocation textureTopLeft;
    private ResourceLocation textureTop;
    private ResourceLocation textureTopRight;
    private ResourceLocation textureRight;
    private ResourceLocation textureBottomRight;
    private ResourceLocation textureBottom;
    private ResourceLocation textureBottomLeft;
    private ResourceLocation textureLeft;
    private double[] coordsTopLeft;
    private double[] coordsTop;
    private double[] coordsTopRight;
    private double[] coordsRight;
    private double[] coordsBottomRight;
    private double[] coordsBottom;
    private double[] coordsBottomLeft;
    private double[] coordsLeft;
    private ResourceLocation textureCircle;
    private ResourceLocation textureCircleMask;
    private ResourceLocation textureCompassPoint;
    private final double tth;
    private final double tlw;
    private final double tbh;
    private final double trw;
    private final double ttlw;
    private final double ttlh;
    private final double ttrw;
    private final double ttrh;
    private final double tblw;
    private final double tblh;
    private final double tbrw;
    private final double tbrh;
    private double x;
    private double y;
    private double width;
    private double height;
    private boolean isSquare;
    private boolean showReticle;
    private int reticleOffsetOuter;
    private int reticleOffsetInner;
    private double reticleThickness;
    private double reticleHeadingThickness;
    private Rectangle2D.Double frameBounds;
    private double[] retNorth = null;
    private double[] retSouth = null;
    private double[] retEast = null;
    private double[] retWest = null;
    private final float frameAlpha;
    public boolean clear = true;

    public ThemeMinimapFrame(Theme theme, Theme.Minimap.MinimapSpec minimapSpec, MiniMapProperties miniMapProperties, double width, double height) {
        this.theme = theme;
        this.minimapSpec = minimapSpec;
        this.width = width;
        this.height = height;
        this.reticleOrientation = (ReticleOrientation)((Object)miniMapProperties.reticleOrientation.get());
        this.clear = false;
        if (minimapSpec instanceof Theme.Minimap.MinimapSquare) {
            this.isSquare = true;
            Theme.Minimap.MinimapSquare minimapSquare = (Theme.Minimap.MinimapSquare)minimapSpec;
            this.resourcePattern = "minimap/square/" + minimapSquare.prefix + "%s.png";
            this.textureTopLeft = this.getTextureResource("topleft");
            this.textureTop = this.getTextureResource("top");
            this.textureTopRight = this.getTextureResource("topright");
            this.textureRight = this.getTextureResource("right");
            this.textureBottomRight = this.getTextureResource("bottomright");
            this.textureBottom = this.getTextureResource("bottom");
            this.textureBottomLeft = this.getTextureResource("bottomleft");
            this.textureLeft = this.getTextureResource("left");
            this.tth = minimapSquare.top.height;
            this.tlw = minimapSquare.left.width;
            this.tbh = minimapSquare.bottom.height;
            this.trw = minimapSquare.right.width;
            this.ttlw = minimapSquare.topLeft.width;
            this.ttlh = minimapSquare.topLeft.height;
            this.ttrw = minimapSquare.topRight.width;
            this.ttrh = minimapSquare.topRight.height;
            this.tblw = minimapSquare.bottomLeft.width;
            this.tblh = minimapSquare.bottomLeft.height;
            this.tbrw = minimapSquare.bottomRight.width;
            this.tbrh = minimapSquare.bottomRight.height;
        } else {
            Theme.Minimap.MinimapCircle minimapCircle = (Theme.Minimap.MinimapCircle)minimapSpec;
            int imgSize = width <= 256.0 ? 256 : 512;
            this.resourcePattern = "minimap/circle/" + minimapCircle.prefix + "%s.png";
            this.textureCircleMask = this.getTextureResource("mask_" + imgSize);
            this.textureCircle = this.getTextureResource("rim_" + imgSize);
            this.tth = 0.0;
            this.tlw = 0.0;
            this.tbh = 0.0;
            this.trw = 0.0;
            this.ttlw = 0.0;
            this.ttlh = 0.0;
            this.ttrw = 0.0;
            this.ttrh = 0.0;
            this.tblw = 0.0;
            this.tblh = 0.0;
            this.tbrw = 0.0;
            this.tbrh = 0.0;
        }
        if (minimapSpec.compassPoint != null && minimapSpec.compassPoint.width > 0 && minimapSpec.compassPoint.height > 0) {
            this.textureCompassPoint = this.getTextureResource("compass_point");
        }
        this.reticleThickness = minimapSpec.reticleThickness;
        this.reticleHeadingThickness = minimapSpec.reticleHeadingThickness;
        this.reticleOffsetOuter = minimapSpec.reticleOffsetOuter;
        this.reticleOffsetInner = minimapSpec.reticleOffsetInner;
        this.showReticle = miniMapProperties.showReticle.get() != false && (minimapSpec.reticle.alpha > 0.0f || minimapSpec.reticleHeading.alpha > 0.0f);
        this.frameAlpha = Math.max(0.0f, Math.min(1.0f, (float)miniMapProperties.frameAlpha.get().intValue() / 100.0f));
    }

    public void setPosition(double x, double y) {
        Theme.ColorSpec colorSpec;
        double thick;
        this.x = x;
        this.y = y;
        this.frameBounds = new Rectangle2D.Double(x, y, this.width, this.height);
        double centerX = x + this.width / 2.0;
        double centerY = y + this.height / 2.0;
        double segLengthNorthSouth = centerY - (double)this.reticleOffsetInner - y - (double)this.reticleOffsetOuter;
        double segLengthEastWest = centerX - (double)this.reticleOffsetInner - x - (double)this.reticleOffsetOuter;
        if (this.reticleOrientation == ReticleOrientation.Compass) {
            thick = this.reticleHeadingThickness;
            colorSpec = this.minimapSpec.reticleHeading;
        } else {
            thick = this.reticleThickness;
            colorSpec = this.minimapSpec.reticle;
        }
        this.retNorth = null;
        if (thick > 0.0 && colorSpec.alpha > 0.0f) {
            this.retNorth = new double[6];
            this.retNorth[0] = centerX - thick / 2.0;
            this.retNorth[1] = y + (double)this.reticleOffsetOuter;
            this.retNorth[2] = thick;
            this.retNorth[3] = segLengthNorthSouth;
            this.retNorth[4] = colorSpec.getColor();
            this.retNorth[5] = colorSpec.alpha;
        }
        if (this.reticleOrientation == ReticleOrientation.PlayerHeading) {
            thick = this.reticleHeadingThickness;
            colorSpec = this.minimapSpec.reticleHeading;
        } else {
            thick = this.reticleThickness;
            colorSpec = this.minimapSpec.reticle;
        }
        this.retSouth = null;
        if (thick > 0.0 && colorSpec.alpha > 0.0f) {
            this.retSouth = new double[6];
            this.retSouth[0] = centerX - thick / 2.0;
            this.retSouth[1] = centerY + (double)this.reticleOffsetInner;
            this.retSouth[2] = thick;
            this.retSouth[3] = segLengthNorthSouth;
            this.retSouth[4] = colorSpec.getColor();
            this.retSouth[5] = colorSpec.alpha;
        }
        thick = this.reticleThickness;
        colorSpec = this.minimapSpec.reticle;
        this.retWest = null;
        if (thick > 0.0 && colorSpec.alpha > 0.0f) {
            this.retWest = new double[6];
            this.retWest[0] = centerX - (double)this.reticleOffsetInner - segLengthEastWest;
            this.retWest[1] = centerY - thick / 2.0;
            this.retWest[2] = segLengthEastWest;
            this.retWest[3] = this.reticleThickness;
            this.retWest[4] = colorSpec.getColor();
            this.retWest[5] = colorSpec.alpha;
        }
        this.retEast = null;
        if (thick > 0.0 && colorSpec.alpha > 0.0f) {
            this.retEast = new double[6];
            this.retEast[0] = centerX + (double)this.reticleOffsetInner;
            this.retEast[1] = centerY - thick / 2.0;
            this.retEast[2] = segLengthEastWest;
            this.retEast[3] = this.reticleThickness;
            this.retEast[4] = colorSpec.getColor();
            this.retEast[5] = colorSpec.alpha;
        }
        if (this.isSquare) {
            int frameColor = this.minimapSpec.frame.getColor();
            float alpha = this.minimapSpec.frame.alpha * this.frameAlpha;
            this.coordsTopLeft = new double[]{frameColor, alpha, x - this.ttlw / 2.0, y - this.ttlh / 2.0, this.ttlw, this.ttlh};
            this.coordsTop = new double[]{frameColor, alpha, x + this.ttlw / 2.0, y - this.tth / 2.0, this.width - this.ttlw / 2.0 - this.ttrw / 2.0, this.tth};
            this.coordsTopRight = new double[]{frameColor, alpha, x + this.width - this.ttrw / 2.0, y - this.ttrh / 2.0, this.ttrw, this.ttrh};
            this.coordsRight = new double[]{frameColor, alpha, x + this.width - this.trw / 2.0, y + this.ttrh / 2.0, this.trw, this.height - this.ttrh / 2.0 - this.tbrh / 2.0};
            this.coordsBottomRight = new double[]{frameColor, alpha, x + this.width - this.tbrw / 2.0, y + this.height - this.tbrh / 2.0, this.tbrw, this.tbrh};
            this.coordsBottom = new double[]{frameColor, alpha, x + this.tblw / 2.0, y + this.height - this.tbh / 2.0, this.width - this.tblw / 2.0 - this.tbrw / 2.0, this.tbh};
            this.coordsBottomLeft = new double[]{frameColor, alpha, x - this.tblw / 2.0, y + this.height - this.tblh / 2.0, this.tblw, this.tblh};
            this.coordsLeft = new double[]{frameColor, alpha, x - this.tlw / 2.0, y + this.ttlh / 2.0, this.tlw, this.height - this.ttlh / 2.0 - this.tblh / 2.0};
        }
    }

    public void drawCircleBackground(GuiGraphics graphics, DisplayVars dv, float alpha) {
        if (!this.isSquare) {
            DrawUtil.blitToCurrentLayer(graphics, RenderPipelines.GUI_TEXTURED, TextureCache.getTexture(this.textureCircleMask).getTextureView(), 0x222222, alpha, dv.getTextureX(), dv.getTextureY(), dv.getMinimapWidth(), dv.getMinimapHeight());
        }
    }

    public ResourceLocation getTextureCircleMask() {
        return this.textureCircleMask;
    }

    public void drawReticle(GuiGraphics graphics) {
        if (this.showReticle) {
            if (this.retNorth != null) {
                DrawUtil.drawFloatRectangle(graphics, this.retNorth[0], this.retNorth[1], this.retNorth[2], this.retNorth[3], (int)this.retNorth[4], (float)this.retNorth[5]);
            }
            if (this.retSouth != null) {
                DrawUtil.drawFloatRectangle(graphics, this.retSouth[0], this.retSouth[1], this.retSouth[2], this.retSouth[3], (int)this.retSouth[4], (float)this.retSouth[5]);
            }
            if (this.retWest != null) {
                DrawUtil.drawFloatRectangle(graphics, this.retWest[0], this.retWest[1], this.retWest[2], this.retWest[3], (int)this.retWest[4], (float)this.retWest[5]);
            }
            if (this.retEast != null) {
                DrawUtil.drawFloatRectangle(graphics, this.retEast[0], this.retEast[1], this.retEast[2], this.retEast[3], (int)this.retEast[4], (float)this.retEast[5]);
            }
        }
    }

    public void drawFrame(GuiGraphics graphics) {
        if (this.minimapSpec.frame.alpha > 0.0f) {
            MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
            if (this.isSquare) {
                this.drawPart(graphics, this.textureTopLeft, this.coordsTopLeft);
                this.drawPart(graphics, this.textureTop, this.coordsTop);
                this.drawPart(graphics, this.textureTopRight, this.coordsTopRight);
                this.drawPart(graphics, this.textureRight, this.coordsRight);
                this.drawPart(graphics, this.textureBottomRight, this.coordsBottomRight);
                this.drawPart(graphics, this.textureBottom, this.coordsBottom);
                this.drawPart(graphics, this.textureBottomLeft, this.coordsBottomLeft);
                this.drawPart(graphics, this.textureLeft, this.coordsLeft);
            } else {
                float alpha = this.minimapSpec.frame.alpha * this.frameAlpha;
                DrawUtil.drawOnMapImage(graphics, this.textureCircle, this.minimapSpec.frame.getColor(), alpha, this.x, this.y, this.width, this.height, 0.0, true);
            }
            buffers.endBatch();
        }
    }

    private void drawPart(GuiGraphics graphics, ResourceLocation textureLocation, double[] parts) {
        double x = parts[2];
        double y = parts[3];
        double width = parts[4];
        double height = parts[5];
        DrawUtil.drawOnMapImage(graphics, textureLocation, (int)parts[0], (float)parts[1], x, y, width, height, 0.0, false);
    }

    public ResourceLocation getCompassPoint() {
        return this.textureCompassPoint;
    }

    private ResourceLocation getTextureResource(String suffix) {
        return TextureCache.getSizedThemeTexture(this.theme, String.format(this.resourcePattern, suffix));
    }

    private AbstractTexture getTexture(String suffix) {
        ResourceLocation loc = TextureCache.getSizedThemeTexture(this.theme, String.format(this.resourcePattern, suffix));
        return TextureCache.getTexture(loc);
    }

    public Rectangle2D.Double getFrameBounds() {
        return this.frameBounds;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public ReticleOrientation getReticleOrientation() {
        return this.reticleOrientation;
    }

    public void clear() {
        this.clear = true;
    }
}

