/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.widgets;

import javax.annotation.Nullable;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;

public abstract class ColoredImageWidget
extends AbstractWidget {
    ColoredImageWidget(int x, int y, int width, int height) {
        super(x, y, width, height, CommonComponents.EMPTY);
    }

    public static ColoredImageWidget texture(int width, int height, ResourceLocation texture, int textureWidth, int textureHeight, int color, boolean blur) {
        return new Image(0, 0, width, height, texture, textureWidth, textureHeight, color, blur);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void playDownSound(SoundManager handler) {
    }

    public boolean isActive() {
        return false;
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        return null;
    }

    public abstract void setColor(int var1);

    public abstract int getColor();

    public abstract void setOutline(boolean var1);

    public abstract void setOutlineColor(int var1);

    public static class Image
    extends ColoredImageWidget {
        private ResourceLocation texture;
        private final int textureWidth;
        private final int textureHeight;
        private int color;
        private final boolean blur;
        private boolean outline = false;
        protected int outlineColor = -1;

        public Image(int x, int y, int width, int height, ResourceLocation texture, int textureWidth, int textureHeight, int color, boolean blur) {
            super(x, y, width, height);
            this.texture = texture;
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.color = RGB.toInteger(RGB.floats(color, 255.0f));
            this.blur = blur;
        }

        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            TextureCache.getTexture(this.texture).setFilter(this.blur, false);
            if (this.outline) {
                this.drawOutline(graphics, mouseX, mouseY, partialTick);
            }
            graphics.blit(RenderPipelines.GUI_TEXTURED, this.getTexture(), this.getX(), this.getY(), 0.0f, 0.0f, this.textureWidth, this.textureHeight, this.textureWidth, this.textureHeight, RGB.toArgb(this.color, 1.0f));
        }

        protected void drawOutline(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            DrawUtil.drawRectangle(graphics, this.getX() - 1, this.getY() - 1, this.getWidth() + 2, this.getHeight() + 2, this.outlineColor, 1.0f);
        }

        @Override
        public void setColor(int color) {
            this.color = color;
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public void setOutline(boolean outline) {
            this.outline = outline;
        }

        @Override
        public void setOutlineColor(int outlineColor) {
            this.outlineColor = outlineColor;
        }

        protected ResourceLocation getTexture() {
            return this.texture;
        }

        public void setTexture(ResourceLocation texture) {
            this.texture = texture;
        }
    }
}

