/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.buttons;

import journeymap.client.Constants;
import journeymap.client.cartography.color.RGB;
import journeymap.client.ui.component.IConfigFieldHolder;
import journeymap.client.ui.component.buttons.AbstractSliderButton;
import journeymap.client.ui.component.buttons.SliderButton;
import journeymap.common.properties.config.IntegerField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class IntSliderButton
extends AbstractSliderButton
implements IConfigFieldHolder<IntegerField>,
SliderButton {
    public String prefix = "";
    public boolean dragging = false;
    public int minValue = 0;
    public int maxValue = 0;
    public String suffix = "";
    public boolean drawString = true;
    IntegerField field;

    public IntSliderButton(IntegerField field, String prefix, String suf) {
        this(field, prefix, suf, true);
    }

    public IntSliderButton(IntegerField field, String prefix, String suf, boolean drawStr) {
        super(field, prefix);
        this.minValue = field.getMinValue();
        this.maxValue = field.getMaxValue();
        this.prefix = prefix;
        this.suffix = suf;
        this.field = field;
        this.setValue(field.get());
        this.disabledLabelColor = RGB.DARK_GRAY_RGBA;
    }

    @Override
    protected void renderBg(GuiGraphics graphics, Minecraft mc, int mouseX, int mouseY) {
        super.renderBg(graphics, mc, mouseX, mouseY);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        if (this.visible && this.isEnabled() && this.isMouseOver(mouseX, mouseY) && this.dragging) {
            this.setSliderValue((mouseX - (double)(super.getX() + 4)) / (double)(this.width - 8));
            if (this.clickListeners != null) {
                this.checkClickListeners();
            }
            return true;
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(super.getX() + 4)) / (double)(this.width - 8));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.mouseOver(mouseX, mouseY) && this.isEnabled()) {
            this.dragging = true;
            this.setValueFromMouse(mouseX);
            this.checkClickListeners();
            return true;
        }
        return false;
    }

    @Override
    public double getSliderValue() {
        return ((double)this.field.get().intValue() - (double)this.minValue * 1.0) / (double)(this.maxValue - this.minValue);
    }

    public void setSliderValue(double sliderValue) {
        if (sliderValue < 0.0) {
            sliderValue = 0.0;
        }
        if (sliderValue > 1.0) {
            sliderValue = 1.0;
        }
        int intVal = (int)Math.round(sliderValue * (double)(this.maxValue - this.minValue) + (double)this.minValue);
        this.setValue(intVal);
    }

    @Override
    public void updateLabel() {
        if (this.drawString) {
            if (this.field.hasCustomMessage()) {
                this.setMessage((Component)Constants.getStringTextComponent(this.field.getCustomMessage()));
            } else {
                this.setMessage((Component)Constants.getStringTextComponent(this.prefix + this.field.get() + this.suffix));
            }
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.dragging) {
            this.dragging = false;
            this.field.save();
            this.checkClickListeners();
        }
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    @Override
    public int getFitWidth(Font fr) {
        int max = fr.width(this.prefix + this.minValue + this.suffix);
        max = Math.max(max, fr.width(this.prefix + this.maxValue + this.suffix));
        return max + this.WIDTH_PAD;
    }

    public boolean keyPressed(int key, int value, int modifier) {
        if (this.isEnabled()) {
            if (key == 263 || key == 45) {
                this.setValue(Math.max(this.minValue, this.getValue() - 1));
                if (this.clickListeners != null) {
                    this.checkClickListeners();
                }
                return true;
            }
            if (key == 262 || key == 61) {
                this.setValue(Math.min(this.maxValue, this.getValue() + 1));
                if (this.clickListeners != null) {
                    this.checkClickListeners();
                }
                return true;
            }
        }
        return false;
    }

    public int getValue() {
        return this.field.get();
    }

    public void setValue(int value) {
        value = Math.min(value, this.field.getMaxValue());
        value = Math.max(value, this.field.getMinValue());
        if (this.field.get() != value) {
            this.field.set((Object)value);
            if (!this.dragging) {
                this.field.save();
            }
        }
        this.updateLabel();
    }

    @Override
    public void refresh() {
        this.setValue(this.field.get());
    }

    @Override
    public IntegerField getConfigField() {
        return this.field;
    }
}

