/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.Map;
import java.util.UUID;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.TextureCache;
import journeymap.common.accessors.NativeImageAccess;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.SkullBlockEntity;

public class IgnSkin {
    public static ResourceLocation DEFAULT_SKIN = ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)"skin/default");
    public static final Map<UUID, DynamicTexture> faceImageCache = Maps.newHashMap();
    public static final Map<UUID, NativeImage> nativeImageCache = Maps.newHashMap();
    private static final Map<UUID, PlayerInfo> playerInfoMap = Maps.newHashMap();

    public static DynamicTexture getFace(GameProfile profile) {
        DynamicTexture face = faceImageCache.get(profile.getId());
        if (face == null) {
            NativeImage nativeImage = nativeImageCache.get(profile.getId());
            if (nativeImage == null) {
                SkullBlockEntity.fetchGameProfile((UUID)profile.getId()).thenAccept(optional -> {
                    GameProfile gameProfile = optional.orElse(profile);
                    nativeImageCache.put(profile.getId(), IgnSkin.getSkin(gameProfile));
                });
                return null;
            }
            face = new DynamicTexture(() -> profile.getName().toLowerCase(), nativeImage);
            faceImageCache.put(profile.getId(), face);
        }
        return face;
    }

    private static NativeImage getSkin(GameProfile profile) {
        try {
            DynamicTexture tex;
            TextureManager textureManager;
            AbstractTexture texture;
            PlayerInfo playerInfo = playerInfoMap.computeIfAbsent(profile.getId(), k -> new PlayerInfo(profile, false));
            PlayerSkin skin = playerInfo.getSkin();
            if (skin != null && (texture = (textureManager = Minecraft.getInstance().getTextureManager()).getTexture(skin.texture())) != null && texture instanceof DynamicTexture && (tex = (DynamicTexture)texture).getPixels() != null) {
                return IgnSkin.cropToFace(tex.getPixels());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static ResourceLocation getDefault() {
        try {
            AbstractTexture texture;
            AbstractTexture skin = TextureCache.getTexture(DEFAULT_SKIN);
            if (skin == null && (texture = TextureCache.getTexture(ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/steve.png"))) != null && texture instanceof DynamicTexture) {
                DynamicTexture tex = (DynamicTexture)texture;
                skin = new DynamicTexture(() -> "default", IgnSkin.cropToFace(tex.getPixels()));
                Minecraft.getInstance().getTextureManager().register(DEFAULT_SKIN, skin);
            }
        }
        catch (Throwable t) {
            Minecraft.getInstance().getTextureManager().register(DEFAULT_SKIN, (AbstractTexture)new DynamicTexture(() -> "blank", ImageUtil.getNewBlankImage(24, 24)));
        }
        return DEFAULT_SKIN;
    }

    public static NativeImage cropToFace(NativeImage playerSkin) {
        NativeImage skin = new NativeImage(playerSkin.getWidth(), playerSkin.getHeight(), false);
        skin.copyFrom(playerSkin);
        if (skin != null && skin.pixels != 0L) {
            if (skin.format().hasAlpha()) {
                NativeImage hat = ImageUtil.getSubImage(40, 8, 8, 8, skin, false);
                for (int x = 0; x < 8; ++x) {
                    for (int y = 0; y < 8; ++y) {
                        int hatPixel = hat.getPixel(x, y);
                        ((NativeImageAccess)skin).blendPixelRGBA(x + 8, y + 8, hatPixel);
                    }
                }
                hat.close();
            }
            NativeImage sub = ImageUtil.getSubImage(8, 8, 8, 8, skin, false);
            return ImageUtil.getSizedImage(24, 24, sub, false);
        }
        return ImageUtil.getNewBlankImage(24, 24);
    }
}

