/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import java.util.HashMap;
import java.util.Map;
import journeymap.client.JourneymapClient;
import journeymap.client.render.draw.MobIconCache;
import journeymap.client.task.main.EnsureCurrentColorsTask;
import journeymap.client.task.main.IMainThreadTask;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;

public class ResourceReloadHandler {
    IMainThreadTask task = new EnsureCurrentColorsTask();
    private static ResourceReloadHandler instance;

    public static ResourceReloadHandler getInstance() {
        if (instance == null) {
            instance = new ResourceReloadHandler();
        }
        return instance;
    }

    public void onResourceReload() {
        if (JourneymapClient.getInstance().enabled()) {
            try {
                TextureCache.reset();
                UIManager.INSTANCE.getMiniMap().reset();
                Fullscreen.state().requireRefresh();
                MiniMap.state().requireRefresh();
                JourneymapClient.getInstance().queueMainThreadTask(this.task);
            }
            catch (Exception e) {
                Journeymap.getLogger().warn("Error handling ResourceReloadHandler: " + LogFormatter.toString(e));
            }
        }
    }

    public Map<ResourceLocation, PreparableReloadListener> getOnResourceReloadHandlers() {
        HashMap<ResourceLocation, PreparableReloadListener> listenerList = new HashMap<ResourceLocation, PreparableReloadListener>();
        listenerList.put(ResourceLocation.parse((String)"journeymap:resource_reload"), (PreparableReloadListener)((ResourceManagerReloadListener)rm -> this.onResourceReload()));
        listenerList.put(ResourceLocation.parse((String)"journeymap:mob_cache"), (PreparableReloadListener)((ResourceManagerReloadListener)rm -> MobIconCache.clearCache()));
        return listenerList;
    }
}

