/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.tiles;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.IPole;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.client.RepaintableBlockModel;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.tiles.ForgeTile;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.Result;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;

public class RepaintableBlockTile
extends ForgeTile {
    public static ForgeConfigSpec.ConfigValue<Boolean> requiresWaterBucket;
    public static ForgeConfigSpec.ConfigValue<Boolean> requiresDye;
    protected BlockState targetBlock = Blocks.AIR.defaultBlockState();

    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() == InteractionHand.MAIN_HAND && !event.getEntity().isShiftKeyDown() && ForgeEntity.hasBrushInHand((LivingEntity)event.getEntity(), InteractionHand.OFF_HAND) && event.getLevel().getBlockEntity(event.getPos()) instanceof RepaintableBlockTile) {
            boolean placeBlock;
            Block block = Block.byItem((Item)event.getEntity().getMainHandItem().getItem());
            boolean bl = placeBlock = block instanceof ISmokeContainer || block instanceof IPole;
            if (!placeBlock) {
                event.setUseItem(Result.DENY);
            }
        }
    }

    public RepaintableBlockTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(RepaintableBlockModel.BLOCK_STATE, (Object)this.targetBlock).build();
    }

    public void setTargetBlock(BlockState newState) {
        if (this.targetBlock != newState) {
            this.targetBlock = newState;
            this.syncWithClients();
        }
    }

    public BlockState getTargetBlock() {
        return this.targetBlock;
    }

    public InteractionResult tryRepaint(Player player, InteractionHand hand) {
        if (this.level == null || !ForgeEntity.hasBrushInHand((LivingEntity)player, hand)) {
            return InteractionResult.PASS;
        }
        InteractionHand otherHand = ForgeEntity.otherHand(hand);
        BlockState sampleBlock = Block.byItem((Item)player.getItemInHand(otherHand).getItem()).defaultBlockState();
        if (this.getTargetBlock() != sampleBlock && this.isProperSample(sampleBlock) && this.hasAllRequiredMaterials(player)) {
            if (!this.level.isClientSide()) {
                this.setTargetBlock(sampleBlock);
                player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                if (((Boolean)requiresDye.get()).booleanValue() && !player.hasInfiniteMaterials()) {
                    Inventory inventory = player.getInventory();
                    ForgeItem.indexIn(inventory, stack -> stack.is(Tags.Items.DYES)).ifPresent(i -> inventory.getItem(i.intValue()).shrink(1));
                }
            }
            this.level.playSound((Entity)player, this.getBlockPos(), SoundEvents.BRUSH_GENERIC, SoundSource.BLOCKS);
        }
        return this.level instanceof ServerLevel ? InteractionResult.SUCCESS_SERVER : InteractionResult.SUCCESS;
    }

    protected boolean hasAllRequiredMaterials(Player player) {
        if (player.getAbilities().instabuild) {
            return true;
        }
        Inventory inventory = player.getInventory();
        boolean hasWater = (Boolean)requiresWaterBucket.get() == false || ForgeItem.indexIn(inventory, stack -> {
            BucketItem bucket;
            Item patt0$temp = stack.getItem();
            return patt0$temp instanceof BucketItem && (bucket = (BucketItem)patt0$temp).getFluid().defaultFluidState().is(FluidTags.WATER);
        }).isPresent();
        boolean hasDye = (Boolean)requiresDye.get() == false || ForgeItem.indexIn(inventory, stack -> stack.is(Tags.Items.DYES)).isPresent();
        return hasWater && hasDye;
    }

    protected boolean isProperSample(BlockState sample) {
        if (sample.isSolidRender()) {
            return true;
        }
        return ForgeBlock.isGlass(sample) && ForgeBlock.isGlass(this.getBlockState());
    }

    @Override
    public void readSharedData(ValueInput input) {
        HolderGetter blockGetter = (HolderGetter)Optional.ofNullable(this.level).map(lvl -> lvl.holderLookup(Registries.BLOCK)).orElse((HolderLookup)BuiltInRegistries.BLOCK);
        this.targetBlock = input.read("target_block", BlockState.CODEC).orElse(Blocks.AIR.defaultBlockState());
        this.requestModelDataUpdate();
        if (this.level != null && this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    @Override
    public void writeSharedData(ValueOutput output) {
        if (!this.targetBlock.isAir()) {
            output.store("target_block", BlockState.CODEC, (Object)this.targetBlock);
        }
    }
}

