/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.items.RepairMatcher;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;

public abstract class DamageableItem
extends ForgeItem {
    protected final List<UnitId> repairMaterials;
    private final boolean repairCostGrow;
    private final int durability;

    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        for (ItemStack stack : new ItemStack[]{event.getLeft(), event.getRight()}) {
            DamageableItem item;
            Item item2 = stack.getItem();
            if (!(item2 instanceof DamageableItem) || (item = (DamageableItem)item2).isRepairCostGrow()) continue;
            DamageableItem.removeRepairPenaltyFor(stack);
        }
    }

    public DamageableItem(UnitConfig config, Properties<?> props) {
        super(config, props);
        String category = props.name;
        this.durability = UnitConfig.getInt(this.getConfig(), category, "durability", props.durability, GameBounds.DURABILITY.getIntBounds(), "Defines durability of the item.");
        this.repairMaterials = this.parseRepairMaterials(this.getConfig(), category, props.repairMaterial.toString());
        this.repairCostGrow = UnitConfig.getBool(this.getConfig(), category, "repairCostGrow", false, "If true, repair cost will grow for this item after each repair using an anvil.");
    }

    protected int getDurability() {
        return this.durability;
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        if (this.getDurability() > 0) {
            stack.set(DataComponents.MAX_DAMAGE, (Object)this.getDurability());
        }
    }

    public static void removeRepairPenaltyFor(ItemStack stack) {
        stack.set(DataComponents.REPAIR_COST, (Object)0);
    }

    public boolean isValidRepairItem(ItemStack material) {
        RepairMatcher matcher = RepairMatcher.from(material);
        for (UnitId id : this.repairMaterials) {
            if (!matcher.matches(id)) continue;
            return true;
        }
        return false;
    }

    public boolean isRepairCostGrow() {
        return this.repairCostGrow;
    }

    public Percentage getWearoutPercentage(ItemStack stack) {
        return Percentage.from(stack.getDamageValue(), stack.getMaxDamage());
    }

    protected List<UnitId> parseRepairMaterials(UnitConfig config, String category, String defaultValue) {
        String stringValue = UnitConfig.getStr(config, category, "repair", defaultValue, "Defines anvil repair materials.\nYou can define several materials by separating them with commas (e.g.: minecraft:leather, #wool)");
        ArrayList<UnitId> list = new ArrayList<UnitId>();
        for (String str : stringValue.split(",")) {
            UnitId id;
            if ((str = str.trim()).isEmpty() || !(id = UnitId.from(str)).notEmpty()) continue;
            list.add(id);
        }
        return list;
    }

    public static class Properties<T extends Properties<T>>
    extends ForgeItem.Properties<T> {
        public int durability;
        public UnitId repairMaterial = UnitId.EMPTY;

        public static ForgeItem.Properties<?> of(ResourceKey<Item> key) {
            return new ForgeItem.Properties<ForgeItem.Properties>(ForgeItem.Properties.class, key);
        }

        protected Properties(Class<T> selfClass, ResourceKey<Item> key) {
            super(selfClass, key);
        }

        public T repairMaterial(UnitId repairMaterial) {
            this.repairMaterial = repairMaterial;
            return (T)((Properties)this.self);
        }

        public T durability(int durability) {
            this.durability = durability;
            this.vanillaProps.durability(durability);
            return (T)((Properties)this.self);
        }
    }
}

