/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.core;

import com.endertech.common.CommonMath;
import com.endertech.common.CommonString;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.client.ItemModel;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.data.DataCollector;
import com.endertech.minecraft.forge.data.Namespace;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.forge.events.ServerTagsUpdatedEvent;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.network.Connection;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractForgeMod {
    protected final List<Runnable> postInitRunnables = new ArrayList<Runnable>();
    protected final DeferredRegister<ArgumentTypeInfo<?, ?>> commandArgumentTypes;
    private final Logger logger = LoggerFactory.getLogger((String)this.getId());
    private final Connection connection = new Connection(this.getId(), this.getRequiredSide());
    private final FMLJavaModLoadingContext context;
    private final Namespace namespace;

    public abstract String getId();

    protected AbstractForgeMod(FMLJavaModLoadingContext context) {
        this.context = context;
        this.namespace = Namespace.of(this.getId());
        this.commandArgumentTypes = DeferredRegister.create((IForgeRegistry)ForgeRegistries.COMMAND_ARGUMENT_TYPES, (String)this.getId());
        BusGroup modBusGroup = this.getBusGroup();
        this.commandArgumentTypes.register(modBusGroup);
        if (this.getRequiredSide() == RequiredSide.BOTH) {
            Connection.enableSynchronization();
        }
        FMLCommonSetupEvent.getBus((BusGroup)modBusGroup).addListener(event -> this.commonInit());
        FMLLoadCompleteEvent.getBus((BusGroup)modBusGroup).addListener(event -> {
            event.enqueueWork(this::runPostInitRunnables);
            event.enqueueWork(this::commonPostInit);
        });
        GatherDataEvent.getBus((BusGroup)modBusGroup).addListener(event -> this.gatherData(new DataCollector(this, (GatherDataEvent)event)));
        ModConfigEvent.Reloading.getBus((BusGroup)modBusGroup).addListener(event -> this.configUpdated(event.getConfig()));
        ServerTagsUpdatedEvent.BUS.addListener(event -> this.tagsUpdated());
        ServerAboutToStartEvent.BUS.addListener(event -> this.serverAboutToStart(event.getServer()));
        ServerStartingEvent.BUS.addListener(event -> this.serverStarting(event.getServer()));
        ServerStoppedEvent.BUS.addListener(event -> this.serverStopped(event.getServer()));
        RegisterCommandsEvent.BUS.addListener(event -> this.registerCommands(ServerCommand.create(this, (CommandDispatcher<CommandSourceStack>)event.getDispatcher()), event.getBuildContext()));
        if (this.isClientSide()) {
            this.clientRegisterItemModelProperties(ItemModel.Properties.of(this));
            FMLClientSetupEvent.getBus((BusGroup)modBusGroup).addListener(event -> this.clientInit());
            ModelEvent.ModifyBakingResult.getBus((BusGroup)modBusGroup).addListener(event -> this.clientReplaceModels(new ItemModel.RegistryWrapper(event.getResults())));
            RegisterParticleProvidersEvent.getBus((BusGroup)modBusGroup).addListener(this::clientRegisterParticleProviders);
            EntityRenderersEvent.AddLayers.getBus((BusGroup)modBusGroup).addListener(event -> this.clientAddRenderLayers());
            EntityRenderersEvent.RegisterRenderers.getBus((BusGroup)modBusGroup).addListener(event -> this.clientRegisterRenderers());
            RegisterKeyMappingsEvent.getBus((BusGroup)modBusGroup).addListener(this::clientRegisterKeyMappings);
            BuildCreativeModeTabContentsEvent.getBus((BusGroup)modBusGroup).addListener(this::clientBuildCreativeModeTab);
        }
    }

    public boolean isClientSide() {
        return FMLEnvironment.dist.isClient();
    }

    public BusGroup getBusGroup() {
        return this.getLoadingContext().getModBusGroup();
    }

    public abstract void commonInit();

    public void commonPostInit() {
    }

    public void commonConfigInit(ConfigValueBuilder value) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientConfigInit(ConfigValueBuilder value) {
    }

    public void configUpdated(ModConfig config) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientAddRenderLayers() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientBuildCreativeModeTab(BuildCreativeModeTabContentsEvent event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientReplaceModels(ItemModel.RegistryWrapper registry) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterRenderers() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterParticleProviders(RegisterParticleProvidersEvent event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterItemModelProperties(ItemModel.Properties<?> props) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterKeyMappings(RegisterKeyMappingsEvent event) {
    }

    public void registerCommands(ServerCommand command, CommandBuildContext buildContext) {
    }

    public void gatherData(DataCollector collector) {
    }

    public void tagsUpdated() {
    }

    protected void serverAboutToStart(MinecraftServer server) {
    }

    protected void serverStarting(MinecraftServer server) {
    }

    protected void serverStopped(MinecraftServer server) {
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public FMLJavaModLoadingContext getLoadingContext() {
        return this.context;
    }

    public RequiredSide getRequiredSide() {
        return RequiredSide.BOTH;
    }

    public void addPostInitRunnable(Runnable method) {
        this.postInitRunnables.add(method);
    }

    protected <MSG extends ForgeNetMsg<MSG>> void registerNetMessage(Supplier<MSG> factory) {
        this.getConnection().registerNetMessage((ForgeNetMsg)factory.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected <T extends Entity> void registerEntityRender(EntityType<T> entityType, EntityRendererProvider<? super T> rendererProvider) {
        EntityRenderers.register(entityType, rendererProvider);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected <T extends BlockEntity> void registerTileRenderer(BlockEntityType<T> tileEntityType, BlockEntityRendererProvider<? super T> rendererProvider) {
        BlockEntityRenderers.register(tileEntityType, rendererProvider);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected <M extends AbstractContainerMenu, U extends Screen> void registerContainerScreen(MenuType<? extends M> type, MenuScreens.ScreenConstructor<M, U> factory) {
        MenuScreens.register(type, factory);
    }

    protected void runPostInitRunnables() {
        this.postInitRunnables.forEach(Runnable::run);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRenderLayer(Block block, ChunkSectionLayer type) {
        ItemBlockRenderTypes.setRenderLayer((Block)block, (ChunkSectionLayer)type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRenderLayer(Fluid fluid, ChunkSectionLayer type) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (ChunkSectionLayer)type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addPlayerRenderLayer(Function<PlayerRenderer, RenderLayer<PlayerRenderState, PlayerModel>> renderLayerFactory) {
        Collection renderers = Minecraft.getInstance().getEntityRenderDispatcher().getSkinMap().values();
        renderers.forEach(renderer -> {
            if (renderer instanceof PlayerRenderer) {
                PlayerRenderer playerRenderer = (PlayerRenderer)renderer;
                playerRenderer.addLayer((RenderLayer)renderLayerFactory.apply(playerRenderer));
            }
        });
    }

    public static boolean isLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static <T> Lazy<Optional<T>> singletonInstance(String modId, Class<T> instanceClass) {
        return Lazy.concurrentOf(() -> {
            if (AbstractForgeMod.isLoaded(modId)) {
                try {
                    Constructor constructor = instanceClass.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    return Optional.of(constructor.newInstance(new Object[0]));
                }
                catch (Exception e) {
                    ForgeEndertech.debugMsg(e.toString());
                }
            }
            return Optional.empty();
        });
    }

    public Path getConfigsDir() {
        return FMLPaths.CONFIGDIR.get().resolve(this.getId());
    }

    protected void registerCommonConfig() {
        this.registerConfig(ModConfig.Type.COMMON, this::commonConfigInit, null);
    }

    protected void registerClientConfig() {
        if (FMLEnvironment.dist.isClient()) {
            this.registerConfig(ModConfig.Type.CLIENT, this::clientConfigInit, null);
        }
    }

    protected void registerConfig(ModConfig.Type type, Consumer<ConfigValueBuilder> init, @Nullable String fileName) {
        ConfigValueBuilder value = new ConfigValueBuilder();
        init.accept(value);
        ForgeConfigSpec spec = value.builder.build();
        FMLJavaModLoadingContext context = this.getLoadingContext();
        if (CommonString.isNullOrEmpty(fileName)) {
            context.registerConfig(type, (IConfigSpec)spec);
        } else {
            context.registerConfig(type, (IConfigSpec)spec, fileName);
        }
    }

    protected <A extends ArgumentType<?>> void registerCommandArgumentType(String name, Class<A> clazz, Supplier<A> supplier) {
        Connection.enableSynchronization();
        this.commandArgumentTypes.register(name, () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass((Class)clazz, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree((Supplier)supplier)));
    }

    public static enum RequiredSide {
        SERVER,
        CLIENT,
        BOTH;

    }

    public static class ConfigValueBuilder {
        public final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();

        public ConfigValueBuilder push(String path) {
            this.builder.push(path);
            return this;
        }

        public ConfigValueBuilder pop() {
            this.builder.pop();
            return this;
        }

        public void shared(String path) {
            this.push(path);
            this.comment("These settings are shared between several mods and therefore located in forgeendertech-common.toml");
            String defaultValue = "I've read the hint and understood";
            this.defineList("whereAreTheSettings?", new String[]{"I've read the hint and understood"}, "I've read the hint and understood"::equals);
            this.pop();
        }

        public ConfigValueBuilder worldRestart() {
            this.builder.worldRestart();
            return this;
        }

        public ConfigValueBuilder comment(String comment) {
            this.builder.comment(comment);
            return this;
        }

        public ForgeConfigSpec.ConfigValue<Boolean> define(String path, boolean defaultValue) {
            return this.builder.define(path, defaultValue);
        }

        public ForgeConfigSpec.ConfigValue<Integer> define(String path, ColorARGB defaultValue) {
            return this.builder.define(path, (Object)defaultValue.getARGB());
        }

        public ForgeConfigSpec.ConfigValue<Integer> defineInRange(String path, int defaultValue, IntBounds bounds) {
            return this.builder.defineInRange(path, defaultValue, bounds.getMin().intValue(), bounds.getMax().intValue());
        }

        public ForgeConfigSpec.ConfigValue<Double> defineInRange(String path, float defaultValue, FloatBounds bounds) {
            int fractDigits = 6;
            return this.builder.defineInRange(path, CommonMath.roundTo(defaultValue, fractDigits), CommonMath.roundTo(bounds.getMin().floatValue(), fractDigits), CommonMath.roundTo(bounds.getMax().floatValue(), fractDigits));
        }

        public <T extends Enum<T>> ForgeConfigSpec.ConfigValue<T> defineEnum(String path, T defaultValue) {
            return this.builder.defineEnum(path, defaultValue);
        }

        public <T extends Enum<T>> ForgeConfigSpec.ConfigValue<T> defineEnum(String path, T defaultValue, Predicate<T> validator) {
            List<Enum> acceptableValues = Stream.of((Enum[])defaultValue.getDeclaringClass().getEnumConstants()).filter(validator).toList();
            return this.builder.defineEnum(path, defaultValue, acceptableValues);
        }

        public ForgeConfigSpec.ConfigValue<Double> defineFactor(String path, float defaultValue) {
            return this.defineInRange(path, defaultValue, GameBounds.FACTOR.getFloatBounds());
        }

        public ForgeConfigSpec.ConfigValue<List<? extends String>> defineList(String path, String[] defaultValues, Predicate<String> validator) {
            return this.builder.defineListAllowEmpty(List.of(path), () -> List.of(defaultValues), object -> {
                String string;
                return object instanceof String && validator.test(string = (String)object);
            });
        }
    }
}

