/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client;

import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.Names;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Tooltip {
    private final ResourceLocation location;
    private final Consumer<Component> consumer;

    public Tooltip(ResourceLocation location, Consumer<Component> consumer) {
        this.location = location;
        this.consumer = consumer;
    }

    public static Tooltip of(AbstractForgeMod mod, String name, Consumer<Component> consumer) {
        return new Tooltip(mod.getNamespace().location(name), consumer);
    }

    protected String expandLangKey(String langKey) {
        return Names.dotted().join("tooltip", this.location.getNamespace(), this.location.getPath(), langKey);
    }

    public Tooltip add(ChatFormatting textFormat, String langKey) {
        return this.add(textFormat, langKey, null);
    }

    public Tooltip add(ChatFormatting textFormat, String langKey, @Nullable Object value) {
        String key = this.expandLangKey(langKey);
        String postfix = value != null ? ": " + String.valueOf(value) : "";
        this.consumer.accept((Component)Component.literal((String)(String.valueOf(textFormat) + I18n.get((String)key, (Object[])new Object[0]) + postfix)));
        return this;
    }

    public Tooltip add(String langKey, Object ... parameters) {
        this.consumer.accept((Component)Component.literal((String)I18n.get((String)this.expandLangKey(langKey), (Object[])parameters)));
        return this;
    }

    public Tooltip addRaw(String string) {
        this.consumer.accept((Component)Component.literal((String)string));
        return this;
    }

    public String button(String langKey, KeyMapping button) {
        String action = langKey.isEmpty() ? "" : I18n.get((String)this.expandLangKey(langKey), (Object[])new Object[0]) + " ";
        return action + button.getTranslatedKeyMessage().getString();
    }
}

