/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.minecraft.forge.units.ITickableUnit;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public interface ITiledBlock<T extends BlockEntity>
extends EntityBlock {
    public T createTile(BlockPos var1, BlockState var2);

    public Class<T> getTileClass();

    default public Optional<T> getTile(BlockGetter level, BlockPos pos) {
        BlockEntity tile = level.getBlockEntity(pos);
        return this.getTileClass().isInstance(tile) ? Optional.of((BlockEntity)this.getTileClass().cast(tile)) : Optional.empty();
    }

    default public <E extends BlockEntity> BlockEntityTicker<E> getTicker(Level levelIn, BlockState stateIn, BlockEntityType<E> typeIn) {
        return (level, pos, state, tile) -> {
            if (tile instanceof ITickableUnit) {
                ITickableUnit unit = (ITickableUnit)tile;
                unit.tick();
            }
        };
    }

    @Nullable
    default public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.createTile(pos, state);
    }
}

