/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.items;

import com.endertech.common.CommonTime;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.client.Tooltip;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.items.GlassMeter;
import com.endertech.minecraft.mods.adfinders.AdFinders;
import com.endertech.minecraft.mods.adfinders.finder.FinderState;
import com.endertech.minecraft.mods.adfinders.finder.Target;
import com.endertech.minecraft.mods.adfinders.init.FinderType;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;

public class Finder
extends GlassMeter {
    public static final CommonTime.Interval UPDATE_INTERVAL = CommonTime.Interval.seconds((double)1.0);
    public static final CommonTime.Interval STATE_TTL = UPDATE_INTERVAL.mult(5.0);
    public static final IntBounds SEARCH_BOUNDS = new IntBounds(Integer.valueOf(1), Integer.valueOf(64));
    public static final int VERT_RANGE = 2;
    public static final float THICKNESS = 0.08f;
    protected final Map<Entity, FinderState> finderStates = new ConcurrentHashMap<Entity, FinderState>();
    protected final Map<String, List<Target>> targetGroups = new ConcurrentSkipListMap<String, List<Target>>();
    protected final List<Target> allTargets = new ArrayList<Target>();
    protected int scanRadius;
    protected int pingDepth;
    protected int veinMinSize;
    protected int depositMinSize;
    protected int durability;
    protected Predicate<BlockState> targetFilter = state -> true;
    private final FinderType type;
    private Future<?> cleaning;
    private CommonTime.Stamp lastCleaning;

    public Finder(FinderType type, GlassMeter.Properties<?> props) {
        super(null, props);
        this.type = type;
        this.durability = props.durability;
    }

    public int getDurability() {
        return this.durability;
    }

    public ChatFormatting getNameColor() {
        return Optional.ofNullable(this.getType().nameColor).map(ForgeConfigSpec.ConfigValue::get).orElse(super.getNameColor());
    }

    public FinderType getType() {
        return this.type;
    }

    public boolean isAllowedTarget(BlockState state) {
        return this.targetFilter.test(state);
    }

    public static Optional<Finder> getFinderItem(ItemStack stack) {
        if (stack != null && !stack.isEmpty() && stack.getItem() instanceof Finder) {
            return Optional.of((Finder)stack.getItem());
        }
        return Optional.empty();
    }

    protected void addTargets(Target ... targets) {
        for (Target target : targets) {
            this.addTarget(target);
        }
    }

    protected void addTarget(Target target) {
        if (target.exists()) {
            String name = target.getName();
            List<Target> group = this.targetGroups.get(name);
            if (group != null) {
                group.add(target);
            } else {
                group = new ArrayList<Target>();
                group.add(target);
                this.targetGroups.put(name, group);
            }
            this.allTargets.add(target);
        }
    }

    protected void addTargets(Collection<Target> targets) {
        for (Target target : targets) {
            this.addTarget(target);
        }
    }

    public void syncTargetsWith(String[] definitions) {
        this.allTargets.clear();
        this.targetGroups.clear();
        for (String definition : definitions) {
            Target target = Target.from(definition);
            this.addTarget(target);
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, @Nullable EquipmentSlot slot, int slotIndex) {
        super.inventoryTick(stack, level, entity, slot, slotIndex);
        this.updateState(stack, entity);
    }

    public void updateState(ItemStack stack, Entity entity) {
        FinderState state;
        if (!ForgeEntity.isClientSide((Entity)entity)) {
            return;
        }
        if (Finder.getFinderItem(stack).isPresent() && Finder.notBroken((ItemStack)stack) && (state = Finder.findStateFor(stack).orElseGet(() -> this.createStateFor(stack, entity).orElse(null))) != null && state.needsUpdate()) {
            state.update(entity);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    Finder.getFinderItem(living.getItemBySlot(slot)).filter(finder -> finder == this).ifPresent(finder -> new FinderState.UpdateMsg(living, slot).sendToServer());
                }
            }
        }
        if ((this.cleaning == null || this.cleaning.isDone()) && (this.lastCleaning == null || CommonTime.Interval.passedFrom((CommonTime.Stamp)this.lastCleaning).moreThan(CommonTime.Interval.seconds((double)10.0)))) {
            this.cleaning = AdFinders.getInstance().executors.submit(this::removeOutdatedStates);
            this.lastCleaning = CommonTime.Stamp.now();
        }
    }

    private void removeOutdatedStates() {
        this.finderStates.values().removeIf(state -> !state.isActual());
        Iterator iterator = this.carriers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ItemStack stack = (ItemStack)entry.getKey();
            Entity entity2 = (Entity)entry.getValue();
            if (!stack.isEmpty() && ForgeEntity.hasStack((Entity)entity2, (ItemStack)stack)) continue;
            iterator.remove();
        }
        this.carriers.values().removeIf(entity -> this.finderStates.get(entity) == null);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        this.updateState(stack, (Entity)entity);
        return super.onEntityItemUpdate(stack, entity);
    }

    protected Optional<FinderState> createStateFor(ItemStack stack, Entity carrier) {
        return Finder.getFinderItem(stack).map(finder -> {
            this.carriers.put(stack, carrier);
            FinderState state = new FinderState((Finder)((Object)finder), carrier);
            this.finderStates.put(carrier, state);
            return state;
        });
    }

    public static Optional<FinderState> findStateFor(ItemStack stack) {
        Entity carrier;
        Finder finder = Finder.getFinderItem(stack).orElse(null);
        if (finder != null && (carrier = (Entity)finder.carriers.get(stack)) != null) {
            return Optional.ofNullable(finder.finderStates.get(carrier));
        }
        return Optional.empty();
    }

    public int getScanRadius() {
        return this.scanRadius;
    }

    public int getPingDepth() {
        return this.pingDepth;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> consumer, TooltipFlag flag) {
        FinderState state = Finder.findStateFor(stack).orElse(null);
        if (state != null) {
            Tooltip tip = Tooltip.of((AbstractForgeMod)AdFinders.getInstance(), (String)"finder", consumer);
            if (Screen.hasShiftDown()) {
                tip.add("needles", new Object[]{ChatFormatting.RESET, ChatFormatting.GREEN});
                tip.add("arrows", new Object[]{ChatFormatting.RESET, ChatFormatting.YELLOW});
                tip.add("red_lights", new Object[]{ChatFormatting.RESET, ChatFormatting.RED});
            } else {
                Finder finder = state.getFinder();
                tip.add(ChatFormatting.GREEN, "scan_radius", (Object)finder.getScanRadius());
                tip.add(ChatFormatting.YELLOW, "ping_depth", (Object)finder.getPingDepth());
                tip.add("more_info", new Object[]{ChatFormatting.GRAY, ChatFormatting.DARK_PURPLE, InputConstants.getKey((String)"key.keyboard.left.shift").getDisplayName().getString()});
            }
        }
        super.appendHoverText(stack, context, display, consumer, flag);
    }

    public Map<String, List<Target>> getTargetGroups() {
        return Collections.unmodifiableMap(this.targetGroups);
    }

    public List<Target> getAllTargets() {
        return Collections.unmodifiableList(this.allTargets);
    }

    public Map<Entity, FinderState> getFinderStates() {
        return Collections.unmodifiableMap(this.finderStates);
    }

    public int getVeinMinSize() {
        return this.veinMinSize;
    }

    public int getDepositMinSize() {
        return this.depositMinSize;
    }

    public static class Properties<T extends Properties<T>>
    extends GlassMeter.Properties<T> {
        public int scanRadius;
        public int pingDepth;
        public int veinMinSize;
        public int depositMinSize;

        public static Properties<?> of(String name) {
            return new Properties<Properties>(Properties.class, (ResourceKey<Item>)ForgeItem.getResourceKey((String)"adfinders", (String)name));
        }

        protected Properties(Class<T> selfClass, ResourceKey<Item> key) {
            super(selfClass, key);
        }

        public T scanRadius(int scanRadius) {
            this.scanRadius = scanRadius;
            return (T)((Object)((Properties)this.self));
        }

        public T pingDepth(int pingDepth) {
            this.pingDepth = pingDepth;
            return (T)((Object)((Properties)this.self));
        }

        public T veinMinSize(int veinMinSize) {
            this.veinMinSize = veinMinSize;
            return (T)((Object)((Properties)this.self));
        }

        public T depositMinSize(int depositMinSize) {
            this.depositMinSize = depositMinSize;
            return (T)((Object)((Properties)this.self));
        }
    }
}

