/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.client.renderer.GlassMeterIndicatorsRenderer;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adfinders.finder.Arrows;
import com.endertech.minecraft.mods.adfinders.finder.FinderState;
import com.endertech.minecraft.mods.adfinders.finder.Needle;
import com.endertech.minecraft.mods.adfinders.init.FinderType;
import com.endertech.minecraft.mods.adfinders.items.Finder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class IndicatorsRenderer
extends GlassMeterIndicatorsRenderer<FinderState> {
    public static final MapCodec<SpecialModelRenderer.Unbaked> CODEC = MapCodec.unit((Object)new SpecialModelRenderer.Unbaked(){

        @Nullable
        public SpecialModelRenderer<?> bake(EntityModelSet modelSet) {
            return new IndicatorsRenderer(modelSet);
        }

        public MapCodec<? extends SpecialModelRenderer.Unbaked> type() {
            return CODEC;
        }
    });

    public IndicatorsRenderer(EntityModelSet modelSet) {
        super(modelSet);
    }

    @Nullable
    public FinderState extractArgument(ItemStack stack) {
        return Finder.findStateFor(stack).orElse(null);
    }

    public void render(@Nullable FinderState finderState, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean hasFoilType) {
        if (finderState == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.translate(0.0f, 0.0f, -0.04f);
        Entity carrier = finderState.getCarrier();
        Vect3d startPos = ForgeEntity.getCenterPosition((Entity)carrier);
        float rotationYaw = carrier.getYRot();
        if (carrier instanceof LivingEntity) {
            Minecraft mc = Minecraft.getInstance();
            if (carrier != mc.player || mc.options.getCameraType() != CameraType.FIRST_PERSON) {
                rotationYaw = ((LivingEntity)carrier).yBodyRot;
            }
        }
        FinderType finder = finderState.getFinder().getType();
        VertexConsumer builder = bufferSource.getBuffer(this.getRenderType());
        float offset = 0.0f;
        for (Arrows.Arrow arrow : finderState.getArrows().values()) {
            if (arrow == null) continue;
            poseStack.translate(0.0f, 0.0f, offset);
            arrow.draw(builder, poseStack, ((Double)finder.arrowSize.get()).floatValue(), (Boolean)finder.drawOutline.get());
            poseStack.translate(0.0f, 0.0f, -offset);
        }
        offset = 0.001f;
        poseStack.translate(0.0f, 0.0f, offset);
        for (Needle needle : finderState.getNeedles()) {
            CommonMath.Angle angle = needle.getAngle(startPos, rotationYaw);
            poseStack.translate(0.0f, 0.0f, offset);
            needle.draw(builder, poseStack, angle, ((Double)finder.needleLength.get()).floatValue(), ((Double)finder.needleWidth.get()).floatValue(), (Boolean)finder.drawOutline.get());
            poseStack.translate(0.0f, 0.0f, -offset);
            offset += 0.001f;
        }
        poseStack.popPose();
    }

    public void getExtents(Set<Vector3f> vectors) {
    }
}

