/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.minecraft.forge.client.renderer.GlassMeterIndicatorsRenderer;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.mods.adfinders.finder.TargetLocation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Objects;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class Indicator {
    public static final ColorARGB OUTLINE_COLOR = ColorARGB.from((Color)Color.WHITE);
    private final ColorARGB color;
    private final TargetLocation location;

    public Indicator(ColorARGB color, TargetLocation location) {
        this.color = color;
        this.location = location;
    }

    public ColorARGB getColor() {
        return this.color;
    }

    public ColorARGB getOutlineColor() {
        return OUTLINE_COLOR;
    }

    public TargetLocation getTargetLocation() {
        return this.location;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void addVertex(VertexConsumer vertexBuilder, PoseStack matrix, float x, float y, float u, float v, ColorARGB color) {
        GlassMeterIndicatorsRenderer.addVertex((VertexConsumer)vertexBuilder, (PoseStack)matrix, (ColorARGB)color, (float)x, (float)y, (float)u, (float)v);
    }

    protected void fill(VertexConsumer builder, PoseStack matrix, float minX, float minY, float maxX, float maxY, ColorARGB color) {
        this.addVertex(builder, matrix, minX, minY, 0.0f, 0.0f, color);
        this.addVertex(builder, matrix, maxX, minY, 1.0f, 0.0f, color);
        this.addVertex(builder, matrix, maxX, maxY, 1.0f, 1.0f, color);
        this.addVertex(builder, matrix, minX, maxY, 0.0f, 1.0f, color);
    }

    protected void outline(VertexConsumer builder, PoseStack matrix, float minX, float minY, float maxX, float maxY, ColorARGB color, float thickness) {
        this.fill(builder, matrix, minX - thickness, minY - thickness, maxX + thickness, minY, color);
        this.fill(builder, matrix, minX - thickness, maxY, maxX + thickness, maxY + thickness, color);
        this.fill(builder, matrix, minX - thickness, minY - thickness, minX, maxY + thickness, color);
        this.fill(builder, matrix, maxX, minY - thickness, maxX + thickness, maxY + thickness, color);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Indicator) {
            Indicator indicator = (Indicator)obj;
            return indicator.getColor().equals((Object)this.getColor()) && indicator.getTargetLocation().equals(this.getTargetLocation());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getColor(), this.getTargetLocation());
    }
}

