/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.service;

import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class SlotSwappingService {
    private static SlotSwappingService INSTANCE;

    public static SlotSwappingService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SlotSwappingService();
        }
        return INSTANCE;
    }

    public void performSlotSwap(AbstractContainerMenu menu, MultiPlayerGameMode gameMode, int containerId, int slot, int targetSlot, LocalPlayer player) {
        this.pickUpItem(menu, gameMode, containerId, slot, player);
        this.pickUpItem(menu, gameMode, containerId, targetSlot, player);
        this.pickUpItem(menu, gameMode, containerId, slot, player);
    }

    private void pickUpItem(AbstractContainerMenu menu, MultiPlayerGameMode gameMode, int containerId, int slot, LocalPlayer player) {
        ItemStack cursorStack = player.containerMenu.getCarried();
        Slot itemSlot = menu.getSlot(slot);
        int mouseButton = 0;
        if (!cursorStack.is(Items.AIR) && itemSlot.getItem().is(ItemTags.BUNDLES) || cursorStack.is(ItemTags.BUNDLES) && !itemSlot.getItem().is(Items.AIR)) {
            mouseButton = 1;
        }
        gameMode.handleInventoryMouseClick(containerId, slot, mouseButton, ClickType.PICKUP, (Player)player);
    }
}

