/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.mixin;

import com.devnemo.nemos.inventory.sorting.config.DefaultConfigValues;
import com.devnemo.nemos.inventory.sorting.config.model.ComponentConfig;
import com.devnemo.nemos.inventory.sorting.config.model.FilterConfig;
import com.devnemo.nemos.inventory.sorting.config.service.ConfigService;
import com.devnemo.nemos.inventory.sorting.factory.ButtonCreator;
import com.devnemo.nemos.inventory.sorting.factory.DropAllButtonFactory;
import com.devnemo.nemos.inventory.sorting.factory.FilterButtonCreator;
import com.devnemo.nemos.inventory.sorting.factory.MoveAllButtonFactory;
import com.devnemo.nemos.inventory.sorting.factory.MoveSameButtonFactory;
import com.devnemo.nemos.inventory.sorting.factory.SortButtonFactory;
import com.devnemo.nemos.inventory.sorting.factory.ToggleFilterPersistenceButtonFactory;
import com.devnemo.nemos.inventory.sorting.gui.components.FilterBox;
import com.devnemo.nemos.inventory.sorting.gui.components.buttons.AbstractFilterToggleButton;
import com.devnemo.nemos.inventory.sorting.gui.components.buttons.AbstractInventoryButton;
import com.devnemo.nemos.inventory.sorting.model.FilterResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BlastFurnaceMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.FurnaceMenu;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SmokerMenu;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin
extends Screen {
    @Shadow
    protected int leftPos;
    @Shadow
    protected int topPos;
    @Shadow
    protected int inventoryLabelY;
    @Shadow
    protected int imageWidth;
    @Unique
    private FilterBox nemosInventorySorting$filterBox;
    @Unique
    private FilterConfig nemosInventorySorting$filterConfig;
    @Unique
    private static final ResourceLocation HIGHLIGHTED_SLOT = ResourceLocation.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"container/highlighted_slot");
    @Unique
    private static final ResourceLocation HIGHLIGHTED_SLOT_INCLUDED_ITEM = ResourceLocation.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"container/highlighted_slot_included_item");
    @Unique
    private static final ResourceLocation DIMMED_SLOT = ResourceLocation.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"container/dimmed_slot");
    @Unique
    private int nemosInventorySorting$inventoryEndIndex;
    @Unique
    private int nemosInventorySorting$containerSize;
    @Unique
    private int nemosInventorySorting$filterBoxWidth = 0;
    @Unique
    private final ConfigService nemosInventorySorting$configService = ConfigService.getInstance();
    @Unique
    private final List<AbstractWidget> nemosInventorySorting$widgets = new ArrayList<AbstractWidget>();

    @Shadow
    public abstract AbstractContainerMenu getMenu();

    protected AbstractContainerScreenMixin(Component component) {
        super(component);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    public void init(CallbackInfo ci) {
        this.nemosInventorySorting$inventoryEndIndex = this.getMenu().slots.size() - 9;
        if (this.getMenu() instanceof InventoryMenu) {
            --this.nemosInventorySorting$inventoryEndIndex;
        }
        this.nemosInventorySorting$containerSize = this.nemosInventorySorting$inventoryEndIndex - 27;
        if (this.nemosInventorySorting$shouldHaveFilter()) {
            List<ComponentConfig> configs = this.nemosInventorySorting$configService.readOrGetDefaultComponentConfigs();
            this.nemosInventorySorting$filterConfig = this.nemosInventorySorting$configService.readOrGetDefaultFilterConfig();
            this.nemosInventorySorting$initFilterBox(configs);
            this.nemosInventorySorting$initFilterButtons(configs);
        }
        if (this.nemosInventorySorting$shouldHaveStorageContainerButtons()) {
            this.nemosInventorySorting$initStorageContainerButtons();
        }
        if (this.nemosInventorySorting$shouldHaveInventoryButtons()) {
            this.nemosInventorySorting$initInventoryButtons();
        }
        if (this.nemosInventorySorting$shouldHaveContainerInventorySortingButtons()) {
            this.nemosInventorySorting$initContainerInventoryButtons();
        }
        for (AbstractWidget widget : this.nemosInventorySorting$widgets) {
            this.addRenderableWidget((GuiEventListener)widget);
        }
    }

    protected void clearWidgets() {
        this.nemosInventorySorting$widgets.clear();
        super.clearWidgets();
    }

    @Unique
    private void nemosInventorySorting$initFilterBox(List<ComponentConfig> configs) {
        Optional<ComponentConfig> optionalComponentConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configs, DefaultConfigValues.ITEM_FILTER);
        if (optionalComponentConfig.isEmpty()) {
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        this.nemosInventorySorting$filterBoxWidth = config.width();
        int xOffset = config.xOffset() != null ? config.xOffset() : this.imageWidth - this.nemosInventorySorting$filterBoxWidth - 3;
        int yOffset = config.yOffset() != null ? config.yOffset() : DefaultConfigValues.Y_OFFSET_ITEM_FILTER;
        this.nemosInventorySorting$createSearchBox(xOffset, yOffset, this.nemosInventorySorting$filterBoxWidth, config.height(), this.nemosInventorySorting$filterConfig.getFilter());
    }

    @Unique
    private void nemosInventorySorting$initFilterButtons(List<ComponentConfig> configs) {
        ToggleFilterPersistenceButtonFactory toggleFilterPersistenceButtonFactory = ToggleFilterPersistenceButtonFactory.getInstance();
        this.nemosInventorySorting$createButton(configs, DefaultConfigValues.FILTER_PERSISTENCE_TOGGLE, toggleFilterPersistenceButtonFactory);
    }

    @Unique
    private void nemosInventorySorting$createButton(List<ComponentConfig> configs, String componentName, FilterButtonCreator filterButtonCreator) {
        Optional<ComponentConfig> optionalComponentConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configs, componentName);
        if (optionalComponentConfig.isEmpty()) {
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        int width = config.width();
        int xOffset = config.xOffset() != null ? config.xOffset() : this.imageWidth - this.nemosInventorySorting$filterBoxWidth - width - 5;
        int yOffset = config.yOffset() != null ? config.yOffset() : DefaultConfigValues.Y_OFFSET_ITEM_FILTER;
        AbstractFilterToggleButton button = filterButtonCreator.createButton(this.leftPos, this.topPos, xOffset, yOffset, width, config.height(), this.nemosInventorySorting$filterConfig);
        this.nemosInventorySorting$widgets.add(button);
    }

    @Inject(method={"onClose"}, at={@At(value="TAIL")})
    private void onClose(CallbackInfo ci) {
        if (this.nemosInventorySorting$filterBox == null) {
            return;
        }
        this.nemosInventorySorting$filterBox.updateAndSaveFilter(this.nemosInventorySorting$filterConfig);
    }

    @Unique
    private void nemosInventorySorting$createSearchBox(int xOffset, int yOffset, int width, int height, String filter) {
        this.nemosInventorySorting$filterBox = new FilterBox(this.font, this.leftPos, this.topPos, xOffset, yOffset, width, height, (Component)Component.translatable((String)"nemos_inventory_sorting.itemFilter"));
        this.addRenderableWidget((GuiEventListener)this.nemosInventorySorting$filterBox);
        this.nemosInventorySorting$filterBox.setValue(filter);
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (this.nemosInventorySorting$filterBox != null && this.nemosInventorySorting$filterBox.isFocused() && keyCode != 256) {
            cir.setReturnValue((Object)this.nemosInventorySorting$filterBox.keyPressed(keyCode, scanCode, modifiers));
            return;
        }
        for (AbstractWidget widget : this.nemosInventorySorting$widgets) {
            if (!widget.keyPressed(keyCode, scanCode, modifiers)) continue;
            cir.setReturnValue((Object)true);
        }
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        for (AbstractWidget widget : this.nemosInventorySorting$widgets) {
            if (!widget.keyReleased(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void mouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        Optional optional = this.getChildAt(mouseX, mouseY);
        if (optional.isEmpty()) {
            for (GuiEventListener guiEventListener : this.children()) {
                guiEventListener.setFocused(false);
            }
        }
        for (AbstractWidget widget : this.nemosInventorySorting$widgets) {
            if (!widget.mouseClicked(mouseX, mouseY, button)) continue;
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"renderContents"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderSlots(Lnet/minecraft/client/gui/GuiGraphics;)V")})
    void renderHighlightedSlot(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!this.nemosInventorySorting$shouldHaveFilter() || this.nemosInventorySorting$filterBox == null) {
            return;
        }
        String filter = this.nemosInventorySorting$filterBox.getValue();
        if (!filter.isEmpty()) {
            Map<FilterResult, List<Slot>> filteredSlotMap = this.nemosInventorySorting$filterBox.filterSlots((NonNullList<Slot>)this.getMenu().slots, filter);
            this.nemosInventorySorting$markSlots(filteredSlotMap.get((Object)FilterResult.INCLUDED), guiGraphics, HIGHLIGHTED_SLOT);
            this.nemosInventorySorting$markSlots(filteredSlotMap.get((Object)FilterResult.HAS_INCLUDED_ITEM), guiGraphics, HIGHLIGHTED_SLOT_INCLUDED_ITEM);
        }
    }

    @Inject(method={"renderContents"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderSlotHighlightFront(Lnet/minecraft/client/gui/GuiGraphics;)V", shift=At.Shift.AFTER)})
    void renderDimmedSlot(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!this.nemosInventorySorting$shouldHaveFilter() || this.nemosInventorySorting$filterBox == null) {
            return;
        }
        String filter = this.nemosInventorySorting$filterBox.getValue();
        if (!filter.isEmpty()) {
            Map<FilterResult, List<Slot>> filteredSlotMap = this.nemosInventorySorting$filterBox.filterSlots((NonNullList<Slot>)this.getMenu().slots, filter);
            this.nemosInventorySorting$markSlots(filteredSlotMap.get((Object)FilterResult.EXCLUDED), guiGraphics, DIMMED_SLOT);
        }
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveFilter() {
        return !(this.getMenu() instanceof CreativeModeInventoryScreen.ItemPickerMenu);
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveStorageContainerButtons() {
        return this.getMenu() instanceof ChestMenu || this.getMenu() instanceof ShulkerBoxMenu;
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveInventoryButtons() {
        return this.getMenu() instanceof InventoryMenu;
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveContainerInventorySortingButtons() {
        AbstractContainerMenu menu = this.getMenu();
        return menu instanceof EnchantmentMenu || menu instanceof FurnaceMenu || menu instanceof SmokerMenu || menu instanceof BlastFurnaceMenu || menu instanceof CraftingMenu || menu instanceof CrafterMenu || menu instanceof GrindstoneMenu || menu instanceof BrewingStandMenu;
    }

    @Unique
    private void nemosInventorySorting$markSlots(List<Slot> slots, GuiGraphics guiGraphics, ResourceLocation texture) {
        if (slots == null) {
            return;
        }
        for (Slot slot : slots) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, texture, slot.x, slot.y, 16, 16);
        }
    }

    @Unique
    private void nemosInventorySorting$initStorageContainerButtons() {
        SortButtonFactory sortButtonFactory = SortButtonFactory.getInstance();
        DropAllButtonFactory dropAllButtonFactory = DropAllButtonFactory.getInstance();
        MoveSameButtonFactory moveSameButtonFactory = MoveSameButtonFactory.getInstance();
        MoveAllButtonFactory moveAllButtonFactory = MoveAllButtonFactory.getInstance();
        List<ComponentConfig> configs = this.nemosInventorySorting$configService.readOrGetDefaultComponentConfigs();
        int yOffset = this.getMenu() instanceof ShulkerBoxMenu ? this.inventoryLabelY - 1 : this.inventoryLabelY - 2;
        this.nemosInventorySorting$createButtonForContainer(configs, DefaultConfigValues.SORT_STORAGE_CONTAINER, sortButtonFactory, DefaultConfigValues.Y_OFFSET_CONTAINER);
        this.nemosInventorySorting$createButtonForContainer(configs, DefaultConfigValues.MOVE_SAME_STORAGE_CONTAINER, moveSameButtonFactory, DefaultConfigValues.Y_OFFSET_CONTAINER);
        this.nemosInventorySorting$createButtonForContainer(configs, DefaultConfigValues.MOVE_ALL_STORAGE_CONTAINER, moveAllButtonFactory, DefaultConfigValues.Y_OFFSET_CONTAINER);
        this.nemosInventorySorting$createButtonForContainer(configs, DefaultConfigValues.DROP_ALL_STORAGE_CONTAINER, dropAllButtonFactory, DefaultConfigValues.Y_OFFSET_CONTAINER);
        this.nemosInventorySorting$createButtonForInventory(configs, DefaultConfigValues.SORT_STORAGE_CONTAINER_INVENTORY, sortButtonFactory, yOffset);
        this.nemosInventorySorting$createButtonForInventory(configs, DefaultConfigValues.MOVE_SAME_STORAGE_CONTAINER_INVENTORY, moveSameButtonFactory, yOffset);
        this.nemosInventorySorting$createButtonForInventory(configs, DefaultConfigValues.MOVE_ALL_STORAGE_CONTAINER_INVENTORY, moveAllButtonFactory, yOffset);
        this.nemosInventorySorting$createButtonForInventory(configs, DefaultConfigValues.DROP_ALL_STORAGE_CONTAINER_INVENTORY, dropAllButtonFactory, yOffset);
    }

    @Unique
    private void nemosInventorySorting$initInventoryButtons() {
        SortButtonFactory sortButtonFactory = SortButtonFactory.getInstance();
        DropAllButtonFactory dropAllButtonFactory = DropAllButtonFactory.getInstance();
        List<ComponentConfig> configs = this.nemosInventorySorting$configService.readOrGetDefaultComponentConfigs();
        this.nemosInventorySorting$createButtonForInventory(configs, DefaultConfigValues.SORT_INVENTORY, sortButtonFactory, DefaultConfigValues.Y_OFFSET_INVENTORY);
        this.nemosInventorySorting$createButtonForInventory(configs, DefaultConfigValues.DROP_ALL_INVENTORY, dropAllButtonFactory, DefaultConfigValues.Y_OFFSET_INVENTORY);
    }

    @Unique
    private void nemosInventorySorting$initContainerInventoryButtons() {
        SortButtonFactory sortButtonFactory = SortButtonFactory.getInstance();
        DropAllButtonFactory dropAllButtonFactory = DropAllButtonFactory.getInstance();
        int yOffset = this.inventoryLabelY - 1;
        List<ComponentConfig> configs = this.nemosInventorySorting$configService.readOrGetDefaultComponentConfigs();
        this.nemosInventorySorting$createButtonForInventory(configs, DefaultConfigValues.SORT_CONTAINER_INVENTORY, sortButtonFactory, yOffset);
        this.nemosInventorySorting$createButtonForInventory(configs, DefaultConfigValues.DROP_ALL_CONTAINER_INVENTORY, dropAllButtonFactory, yOffset);
    }

    @Unique
    private void nemosInventorySorting$createButtonForContainer(List<ComponentConfig> configs, String componentName, ButtonCreator buttonCreator, int defaultYOffset) {
        Optional<ComponentConfig> optionalComponentConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configs, componentName);
        if (optionalComponentConfig.isEmpty()) {
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        int yOffset = config.yOffset() != null ? config.yOffset() : defaultYOffset;
        this.nemosInventorySorting$createContainerButton(buttonCreator, config.xOffset(), yOffset, config.width(), config.height());
    }

    @Unique
    private void nemosInventorySorting$createButtonForInventory(List<ComponentConfig> configs, String componentName, ButtonCreator buttonCreator, int defaultYOffset) {
        Optional<ComponentConfig> optionalComponentConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configs, componentName);
        if (optionalComponentConfig.isEmpty()) {
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        int yOffset = config.yOffset() != null ? config.yOffset() : defaultYOffset;
        this.nemosInventorySorting$createInventoryButton(buttonCreator, config.xOffset(), yOffset, config.width(), config.height());
    }

    @Unique
    private void nemosInventorySorting$createContainerButton(ButtonCreator buttonCreator, int xOffset, int yOffset, int width, int height) {
        this.nemosInventorySorting$createButton(buttonCreator, 0, this.nemosInventorySorting$containerSize, xOffset, yOffset, width, height, false);
    }

    @Unique
    private void nemosInventorySorting$createInventoryButton(ButtonCreator buttonCreator, int xOffset, int yOffset, int width, int height) {
        this.nemosInventorySorting$createButton(buttonCreator, this.nemosInventorySorting$containerSize, this.nemosInventorySorting$inventoryEndIndex, xOffset, yOffset, width, height, true);
    }

    @Unique
    private void nemosInventorySorting$createButton(ButtonCreator buttonCreator, int startIndex, int endIndex, int xOffset, int yOffset, int width, int height, boolean isInventoryButton) {
        AbstractInventoryButton sortButton = buttonCreator.createButton(startIndex, endIndex, this.leftPos, this.topPos, xOffset, yOffset, width, height, this.getMenu(), isInventoryButton);
        this.nemosInventorySorting$widgets.add(sortButton);
    }
}

