/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup.storage;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.util.Holder;
import com.supermartijn642.packedup.BackpackItem;
import com.supermartijn642.packedup.BackpackType;
import com.supermartijn642.packedup.PackedUpConfig;
import com.supermartijn642.packedup.storage.BackpackInventory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BackpackStorageManager {
    private static Path directory;
    private static long lastSaveTimestamp;
    private static final HashMap<Integer, BackpackInventory> inventories;
    private static int inventoryIndex;
    public static final Supplier<Integer> maxLayers;

    @SubscribeEvent
    public static void onLevelSave(LevelEvent.Save event) {
        if (event.getLevel().isClientSide() || !(event.getLevel() instanceof Level) || ((Level)event.getLevel()).dimension() != Level.OVERWORLD && System.currentTimeMillis() - lastSaveTimestamp < 30000L) {
            return;
        }
        BackpackStorageManager.save((HolderLookup.Provider)event.getLevel().registryAccess());
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        if (event.getLevel().isClientSide() || !(event.getLevel() instanceof Level) || ((Level)event.getLevel()).dimension() != Level.OVERWORLD) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        directory = level.getServer().getWorldPath(LevelResource.ROOT).resolve("packedup/backpacks");
        BackpackStorageManager.load((HolderLookup.Provider)level.registryAccess());
    }

    public static BackpackInventory getInventory(int index) {
        Path file;
        BackpackInventory inventory = inventories.get(index);
        if (inventory == null && Files.exists(file = directory.resolve("inventory" + index + ".nbt"), new LinkOption[0])) {
            inventory = new BackpackInventory(false, index);
            inventory.load(file, (HolderLookup.Provider)CommonUtils.getRegistryAccess());
            inventories.put(index, inventory);
        }
        return inventory;
    }

    public static int createInventoryIndex(BackpackType type) {
        int index = inventoryIndex++;
        inventories.put(index, new BackpackInventory(false, index, type.getSlots()));
        return index;
    }

    public static void save(HolderLookup.Provider provider) {
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        for (int i : inventories.keySet()) {
            inventories.get(i).save(directory.resolve("inventory" + i + ".nbt"), provider);
        }
        lastSaveTimestamp = System.currentTimeMillis();
    }

    public static void load(HolderLookup.Provider provider) {
        BackpackInventory inventory;
        inventories.clear();
        Holder highest = new Holder((Object)-1);
        if (Files.exists(directory, new LinkOption[0])) {
            try (Stream<Path> files = Files.list(directory);){
                files.forEach(file -> {
                    int index;
                    if (!Files.isRegularFile(file, new LinkOption[0])) {
                        return;
                    }
                    String name = file.getFileName().toString();
                    if (!name.startsWith("inventory") || !name.endsWith(".nbt")) {
                        return;
                    }
                    try {
                        index = Integer.parseInt(name.substring("inventory".length(), name.length() - ".nbt".length()));
                    }
                    catch (NumberFormatException e) {
                        return;
                    }
                    if (index > (Integer)highest.get()) {
                        highest.set((Object)index);
                    }
                    BackpackInventory inventory = new BackpackInventory(false, index);
                    inventory.load((Path)file, provider);
                    inventory.bagsThisBagIsIn.clear();
                    inventory.bagsThisBagIsDirectlyIn.clear();
                    inventory.bagsInThisBag.clear();
                    inventory.bagsDirectlyInThisBag.clear();
                    inventory.layer = 0;
                    inventories.put(index, inventory);
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        inventoryIndex = (Integer)highest.get() + 1;
        for (Map.Entry<Integer, BackpackInventory> entry : inventories.entrySet()) {
            inventory = entry.getValue();
            for (ItemStack stack : inventory.getStacks()) {
                if (!(stack.getItem() instanceof BackpackItem) || !stack.has(BackpackItem.INVENTORY_ID)) continue;
                int index = (Integer)stack.get(BackpackItem.INVENTORY_ID);
                if (!inventories.containsKey(index)) {
                    stack.remove(BackpackItem.INVENTORY_ID);
                    continue;
                }
                inventory.bagsDirectlyInThisBag.add(index);
                BackpackStorageManager.inventories.get((Object)Integer.valueOf((int)index)).bagsThisBagIsDirectlyIn.add(entry.getKey());
            }
        }
        for (Map.Entry<Integer, BackpackInventory> entry : inventories.entrySet()) {
            inventory = entry.getValue();
            inventory.layer = BackpackStorageManager.getBagsThisBagIsIn(entry.getKey(), inventory.bagsThisBagIsIn);
            BackpackStorageManager.getBagsInThisBag(entry.getKey(), inventory.bagsInThisBag);
        }
        BackpackStorageManager.save(provider);
        inventories.clear();
    }

    private static Integer getBagsThisBagIsIn(int index, Set<Integer> bags) {
        if (BackpackStorageManager.getInventory(index) == null) {
            return 0;
        }
        int highest = 0;
        for (int id : BackpackStorageManager.getInventory((int)index).bagsThisBagIsDirectlyIn) {
            if (bags.contains(id)) continue;
            bags.add(id);
            highest = Math.max(highest, BackpackStorageManager.getBagsThisBagIsIn(id, bags)) + 1;
        }
        return highest;
    }

    private static void getBagsInThisBag(int index, Set<Integer> bags) {
        if (BackpackStorageManager.getInventory(index) == null) {
            return;
        }
        for (int id : BackpackStorageManager.getInventory((int)index).bagsDirectlyInThisBag) {
            if (bags.contains(id)) continue;
            bags.add(id);
            BackpackStorageManager.getBagsInThisBag(id, bags);
        }
    }

    public static void onInsert(int index, int to) {
        BackpackStorageManager.getInventory((int)index).bagsThisBagIsDirectlyIn.add(to);
        BackpackStorageManager.getInventory((int)to).bagsDirectlyInThisBag.add(index);
        BackpackStorageManager.updateRelativeBags(index, to);
    }

    public static void onExtract(int index, int from) {
        BackpackStorageManager.getInventory((int)index).bagsThisBagIsDirectlyIn.remove(from);
        BackpackStorageManager.getInventory((int)from).bagsDirectlyInThisBag.remove(index);
        BackpackStorageManager.updateRelativeBags(index, from);
    }

    private static void updateRelativeBags(int child, int parent) {
        BackpackInventory inv;
        BackpackInventory childInventory = BackpackStorageManager.getInventory(child);
        BackpackInventory parentInventory = BackpackStorageManager.getInventory(parent);
        Set<Integer> bagsBefore = parentInventory.bagsThisBagIsIn;
        bagsBefore.add(parent);
        Set<Integer> bagsAfter = childInventory.bagsInThisBag;
        bagsAfter.add(child);
        for (int id : bagsBefore) {
            inv = BackpackStorageManager.getInventory(id);
            inv.bagsInThisBag.clear();
            BackpackStorageManager.getBagsInThisBag(id, inv.bagsInThisBag);
        }
        for (int id : bagsAfter) {
            inv = BackpackStorageManager.getInventory(id);
            inv.bagsThisBagIsIn.clear();
            inv.layer = BackpackStorageManager.getBagsThisBagIsIn(id, inv.bagsThisBagIsIn);
        }
    }

    static {
        lastSaveTimestamp = 0L;
        inventories = new HashMap();
        inventoryIndex = 0;
        maxLayers = () -> PackedUpConfig.allowBagInBag.get() != false ? PackedUpConfig.maxBagInBagLayer.get() : 0;
    }
}

