/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup.screen.customization;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.packedup.BackpackItem;
import com.supermartijn642.packedup.PackedUp;
import com.supermartijn642.packedup.packets.PacketSetIcon;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class IconSlotWidget
extends BaseWidget {
    public static final ResourceLocation ICON_SLOT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"packedup", (String)"gui/icon_slot");
    private final InteractionHand hand;
    private final Supplier<ItemStack> backpackSupplier;
    private final Runnable selectionScreen;

    public IconSlotWidget(int x, int y, InteractionHand hand, Supplier<ItemStack> backpack, Runnable selectionScreen) {
        super(x, y, 20, 20);
        this.hand = hand;
        this.backpackSupplier = backpack;
        this.selectionScreen = selectionScreen;
    }

    public Component getNarrationMessage() {
        return TextComponents.translation((String)"packedup.customization_screen.icon").get();
    }

    public boolean mouseReleased(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        if (!hasBeenHandled && this.isFocused()) {
            if (button == 0) {
                this.selectionScreen.run();
            } else if (button == 1) {
                PackedUp.CHANNEL.sendToServer((BasePacket)new PacketSetIcon(this.hand, ItemStack.EMPTY));
                hasBeenHandled = true;
            }
        }
        return super.mousePressed(mouseX, mouseY, button, hasBeenHandled);
    }

    protected void getTooltips(Consumer<Component> tooltips) {
        ItemStack icon = BackpackItem.getIcon(this.backpackSupplier.get());
        tooltips.accept((Component)TextComponents.translation((String)"packedup.customization_screen.icon").get());
        if (icon.isEmpty()) {
            tooltips.accept((Component)TextComponents.translation((String)"packedup.customization_screen.icon.none").italic().color(ChatFormatting.DARK_GRAY).get());
        } else {
            tooltips.accept((Component)TextComponents.itemStack((ItemStack)icon).italic().color(ChatFormatting.GRAY).get());
        }
        tooltips.accept((Component)TextComponents.translation((String)"packedup.customization_screen.icon.select", (Object[])new Object[]{TextComponents.translation((String)"packedup.customization_screen.icon.left_click").color(ChatFormatting.GOLD).get()}).color(ChatFormatting.WHITE).get());
        tooltips.accept((Component)TextComponents.translation((String)"packedup.customization_screen.icon.clear", (Object[])new Object[]{TextComponents.translation((String)"packedup.customization_screen.icon.right_click").color(ChatFormatting.GOLD).get()}).color(ChatFormatting.WHITE).get());
    }

    public void renderBackground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        super.renderBackground(context, graphics, mouseX, mouseY);
        graphics.submitSprite(ICON_SLOT_TEXTURE, (float)this.x, (float)this.y, (float)this.width, (float)this.height, p -> p.uv(this.isFocused() ? 0.5f : 0.0f, 0.0f, 0.5f, 1.0f));
    }

    public void render(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        super.render(context, graphics, mouseX, mouseY);
        graphics.submitItem(this.backpackSupplier.get(), (float)(this.x + 2), (float)(this.y + 2), p -> p.level(ClientUtils.getWorld()));
    }
}

