/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup.screen.customization;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.WidgetScreen;
import com.supermartijn642.core.gui.widget.ItemBaseWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.TextFieldWidget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.packedup.BackpackItem;
import com.supermartijn642.packedup.PackedUp;
import com.supermartijn642.packedup.packets.PacketRename;
import com.supermartijn642.packedup.screen.customization.IconSelectionScreen;
import com.supermartijn642.packedup.screen.customization.IconSlotWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BackpackCustomizationScreen
extends ItemBaseWidget {
    private static final int MAX_NAME_CHARACTER_COUNT = 23;
    private static final Component TITLE = TextComponents.translation((String)"packedup.customization_screen.title").get();
    private final InteractionHand hand;
    private TextFieldWidget nameField;

    public BackpackCustomizationScreen(InteractionHand hand) {
        super(0, 0, 192, 48, () -> ClientUtils.getPlayer().getItemInHand(hand), s -> !s.isEmpty() && s.getItem() instanceof BackpackItem);
        this.hand = hand;
    }

    public Component getNarrationMessage(ItemStack stack) {
        return TITLE;
    }

    protected void addWidgets(ItemStack stack) {
        String currentName = TextComponents.itemStack((ItemStack)stack).format();
        String defaultName = TextComponents.item((Item)stack.getItem()).format();
        this.nameField = (TextFieldWidget)this.addWidget((Widget)new TextFieldWidget(34, 20, 150, 20, currentName, 23, name -> PackedUp.CHANNEL.sendToServer((BasePacket)new PacketRename(this.hand, (String)name))));
        this.nameField.setSuggestion(defaultName);
        this.nameField.setFocused(true);
        this.addWidget((Widget)new IconSlotWidget(8, 20, this.hand, () -> (ItemStack)this.object, () -> ClientUtils.getMinecraft().setScreen((Screen)WidgetScreen.of((Widget)new IconSelectionScreen(this.hand)))));
    }

    protected void renderBackground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY, ItemStack stack) {
        graphics.submitDefaultScreenBackground(0.0f, 0.0f, (float)this.width(), (float)this.height());
        super.renderBackground(context, graphics, mouseX, mouseY, (Object)stack);
    }

    public void render(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY, ItemStack stack) {
        graphics.submitText((FormattedText)TITLE, 9.0f, 7.0f, p -> p.color(0x404040));
        super.render(context, graphics, mouseX, mouseY, (Object)stack);
    }

    public boolean keyPressed(int keyCode, boolean hasBeenHandled, ItemStack stack) {
        if (!hasBeenHandled && this.nameField.isSelected() && keyCode == 257) {
            ((LocalPlayer)ClientUtils.getPlayer()).closeContainer();
            hasBeenHandled = true;
        }
        hasBeenHandled |= super.keyPressed(keyCode, hasBeenHandled, (Object)stack);
        return hasBeenHandled;
    }
}

