/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup.screen;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.BaseContainerWidget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.packedup.PackedUpClient;
import com.supermartijn642.packedup.screen.BackpackContainer;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class BackpackContainerScreen
extends BaseContainerWidget<BackpackContainer> {
    public static final ResourceLocation CORNERS = ResourceLocation.fromNamespaceAndPath((String)"packedup", (String)"gui/corners");
    private Component displayName;

    public BackpackContainerScreen() {
        super(0, 0, 0, 0);
    }

    public void initialize() {
        super.initialize();
        this.displayName = BackpackContainerScreen.trimText(((BackpackContainer)this.container).bagName, ((BackpackContainer)this.container).type.getColumns() * 18);
    }

    public Component getNarrationMessage() {
        return this.displayName;
    }

    public int width() {
        return ((BackpackContainer)this.container).type.getColumns() > 9 ? 14 + ((BackpackContainer)this.container).type.getColumns() * 18 : 176;
    }

    public int height() {
        return 112 + 18 * ((BackpackContainer)this.container).type.getRows();
    }

    public void renderBackground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        if (((BackpackContainer)this.container).type.getColumns() == 9) {
            graphics.submitDefaultScreenBackground(0.0f, 0.0f, (float)this.width(), (float)this.height());
        } else {
            int backpackWidth = ((BackpackContainer)this.container).type.getColumns() * 18 + 14;
            int offset = (this.width() - backpackWidth) / 2;
            int height = ((BackpackContainer)this.container).type.getRows() * 18 + 23;
            graphics.submitDefaultScreenBackground((float)offset, 0.0f, (float)backpackWidth, (float)height);
            graphics.submitDefaultScreenBackground(Math.max(0.0f, (float)(backpackWidth - 176) / 2.0f), (float)(height - 9), 176.0f, (float)(this.height() - height + 9));
            if (((BackpackContainer)this.container).type.getColumns() > 9) {
                graphics.submitSprite(CORNERS, Math.max(0.0f, (float)(backpackWidth - 176) / 2.0f), (float)(height - 3), 3.0f, 3.0f, p -> p.uv(0.0f, 0.0f, 0.5f, 0.5f));
                graphics.submitSprite(CORNERS, Math.max(0.0f, (float)(backpackWidth - 176) / 2.0f) + 176.0f - 3.0f, (float)(height - 3), 3.0f, 3.0f, p -> p.uv(0.5f, 0.0f, 0.5f, 0.5f));
                graphics.submitRectangle(Math.max(0.0f, (float)(backpackWidth - 176) / 2.0f), (float)(height - 9), 176.0f, 6.0f, p -> p.color(-3750202));
            } else {
                graphics.submitSprite(CORNERS, (float)offset, (float)(height - 9), 3.0f, 3.0f, p -> p.uv(0.0f, 0.5f, 0.5f, 0.5f));
                graphics.submitSprite(CORNERS, (float)(offset + backpackWidth - 3), (float)(height - 9), 3.0f, 3.0f, p -> p.uv(0.5f, 0.5f, 0.5f, 0.5f));
                graphics.submitRectangle((float)(offset + 3), (float)(height - 9), (float)(backpackWidth - 6), 3.0f, p -> p.color(-3750202));
            }
        }
        super.renderBackground(context, graphics, mouseX, mouseY);
    }

    public void renderForeground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        int offset = (((BackpackContainer)this.container).type.getColumns() - 9) * 18 / 2;
        graphics.submitText((FormattedText)this.displayName, (float)(8 - Math.min(0, offset)), 6.0f, p -> p.color(0x404040));
        graphics.submitText((FormattedText)ClientUtils.getPlayer().getInventory().getDisplayName(), (float)(8 + Math.max(0, offset)), (float)(this.height() - 96 + 3), p -> p.color(0x404040));
        super.renderForeground(context, graphics, mouseX, mouseY);
    }

    public boolean keyPressed(int keyCode, boolean hasBeenHandled) {
        if (!(hasBeenHandled |= super.keyPressed(keyCode, hasBeenHandled)) && PackedUpClient.OPEN_BAG_KEY.matches(keyCode, -1)) {
            ((BackpackContainer)this.container).player.closeContainer();
            hasBeenHandled = true;
        }
        return hasBeenHandled;
    }

    private static Component trimText(Component textComponent, int width) {
        int length;
        String text = TextComponents.format((Component)textComponent);
        Font font = ClientUtils.getFontRenderer();
        for (length = 0; length < text.length() && font.width(text.substring(0, length + 1) + "...") < width; ++length) {
        }
        return TextComponents.string((String)(length < text.length() ? text.substring(0, length) + "..." : text)).get();
    }
}

