/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.packedup.BackpackItem;
import com.supermartijn642.packedup.BackpackType;
import com.supermartijn642.packedup.PackedUpConfig;
import com.supermartijn642.packedup.screen.BackpackContainer;
import com.supermartijn642.packedup.storage.BackpackInventory;
import com.supermartijn642.packedup.storage.BackpackStorageManager;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PackedUpCommon {
    public static void openBackpackInventory(ItemStack stack, Player player, int bagSlot) {
        PackedUpCommon.updateOldBackpack(stack);
        BackpackType type = ((BackpackItem)stack.getItem()).type;
        MutableComponent name = TextComponents.itemStack((ItemStack)stack).get();
        Integer inventoryIndex = (Integer)stack.get(BackpackItem.INVENTORY_ID);
        if (inventoryIndex == null || BackpackStorageManager.getInventory(inventoryIndex) == null) {
            inventoryIndex = BackpackStorageManager.createInventoryIndex(type);
            stack.set(BackpackItem.INVENTORY_ID, (Object)inventoryIndex);
        } else {
            BackpackStorageManager.getInventory(inventoryIndex).adjustSize(type);
        }
        BackpackInventory inventory = BackpackStorageManager.getInventory(inventoryIndex);
        CommonUtils.openContainer((BaseContainer)new BackpackContainer(player, bagSlot, (Component)name, inventoryIndex, type, inventory.bagsInThisBag, inventory.bagsThisBagIsIn, inventory.layer));
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDropsEvent e) {
        List<ItemEntity> stacksToBeSaved;
        if (e.getEntity() instanceof Player && PackedUpConfig.keepBackpacksOnDeath.get().booleanValue() && !(stacksToBeSaved = e.getDrops().stream().filter(itemEntity -> itemEntity.isAlive() && !itemEntity.getItem().isEmpty() && itemEntity.getItem().getItem() instanceof BackpackItem).toList()).isEmpty()) {
            stacksToBeSaved.forEach(e.getDrops()::remove);
            ListTag itemData = new ListTag();
            RegistryOps ops = e.getEntity().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            stacksToBeSaved.stream().map(ItemEntity::getItem).map(item -> (Tag)ItemStack.CODEC.encodeStart((DynamicOps)ops, item).getOrThrow()).forEach(arg_0 -> itemData.add(arg_0));
            e.getEntity().getPersistentData().put("packedup:backpacks", (Tag)itemData);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone e) {
        ListTag itemData = e.getOriginal().getPersistentData().getListOrEmpty("packedup:backpacks");
        RegistryOps ops = e.getEntity().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        itemData.stream().map(tag -> ItemStack.CODEC.decode((DynamicOps)ops, tag)).filter(DataResult::isSuccess).map(result -> (ItemStack)((Pair)result.getOrThrow()).getFirst()).forEach(stack -> e.getEntity().getInventory().placeItemBackInInventory(stack));
    }

    private static void updateOldBackpack(ItemStack stack) {
        CustomData data;
        if (stack.has(DataComponents.CUSTOM_DATA) && (data = (CustomData)stack.get(DataComponents.CUSTOM_DATA)) != null && data.getUnsafe().getInt("packedup:invIndex").isPresent()) {
            stack.set(BackpackItem.INVENTORY_ID, (Object)((Integer)data.copyTag().getInt("packedup:invIndex").get()));
            if (data.getUnsafe().size() <= 1) {
                stack.remove(DataComponents.CUSTOM_DATA);
            } else {
                stack.set(DataComponents.CUSTOM_DATA, (Object)data.update(t -> t.remove("packedup:invIndex")));
            }
        }
    }
}

