/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.packedup.BackpackItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class BackpackUpgradeRecipe
extends ShapedRecipe {
    public static final RecipeSerializer<BackpackUpgradeRecipe> SERIALIZER = new Serializer();
    private final String group;
    private final CraftingBookCategory category;
    private final ShapedRecipePattern pattern;
    private final ItemStack result;
    private final boolean showNotification;

    public BackpackUpgradeRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack recipeOutput, boolean showNotification) {
        super(group, category, pattern, recipeOutput, showNotification);
        this.group = group;
        this.category = category;
        this.pattern = pattern;
        this.result = recipeOutput;
        this.showNotification = showNotification;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        for (int index = 0; index < input.ingredientCount(); ++index) {
            ItemStack stack = input.getItem(index);
            if (stack.isEmpty() || !(stack.getItem() instanceof BackpackItem) || !stack.has(BackpackItem.INVENTORY_ID)) continue;
            ItemStack result = this.result.copy();
            result.set(BackpackItem.INVENTORY_ID, (Object)((Integer)stack.get(BackpackItem.INVENTORY_ID)));
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                result.set(DataComponents.CUSTOM_NAME, (Object)((Component)stack.get(DataComponents.CUSTOM_NAME)));
            }
            if (stack.has(DataComponents.ENCHANTMENTS)) {
                result.set(DataComponents.ENCHANTMENTS, (Object)((ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS)));
            }
            return result;
        }
        return this.result.copy();
    }

    private static class Serializer
    implements RecipeSerializer<BackpackUpgradeRecipe> {
        private static final MapCodec<BackpackUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(recipe -> recipe.category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(recipe -> recipe.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(recipe -> recipe.showNotification)).apply((Applicative)instance, BackpackUpgradeRecipe::new));

        private Serializer() {
        }

        public MapCodec<BackpackUpgradeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BackpackUpgradeRecipe> streamCodec() {
            return StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);
        }

        public static BackpackUpgradeRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            return Serializer.fromShapedRecipe(ShapedRecipe.Serializer.fromNetwork((RegistryFriendlyByteBuf)buffer));
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, BackpackUpgradeRecipe recipe) {
            ShapedRecipe.Serializer.toNetwork((RegistryFriendlyByteBuf)buffer, (ShapedRecipe)recipe);
        }

        private static BackpackUpgradeRecipe fromShapedRecipe(ShapedRecipe recipe) {
            return new BackpackUpgradeRecipe(recipe.group(), recipe.category(), recipe.pattern, recipe.assemble(null, null), recipe.showNotification());
        }
    }
}

