/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.item.BaseItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.packedup.BackpackType;
import com.supermartijn642.packedup.PackedUp;
import com.supermartijn642.packedup.PackedUpClient;
import com.supermartijn642.packedup.PackedUpCommon;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class BackpackItem
extends BaseItem {
    public static final DataComponentType<Integer> INVENTORY_ID = DataComponentType.builder().persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.INT).build();
    public static final DataComponentType<Icon> ICON_ITEM = DataComponentType.builder().persistent(ItemStack.OPTIONAL_CODEC.xmap(Icon::new, Icon::stack)).networkSynchronized(ItemStack.OPTIONAL_STREAM_CODEC.map(Icon::new, Icon::stack)).build();
    public BackpackType type;

    public static ItemStack getIcon(ItemStack stack) {
        Icon icon = (Icon)stack.get(ICON_ITEM);
        return icon == null ? ItemStack.EMPTY : icon.stack;
    }

    public static void setIcon(ItemStack stack, ItemStack icon) {
        if (icon.isEmpty()) {
            stack.remove(ICON_ITEM);
        } else {
            if (icon.has(ICON_ITEM)) {
                icon = icon.copy();
                icon.remove(ICON_ITEM);
            }
            stack.set(ICON_ITEM, (Object)new Icon(icon));
        }
    }

    public BackpackItem(BackpackType type) {
        super(type.isEnabled() ? ItemProperties.create().maxStackSize(1).group(PackedUp.ITEM_GROUP) : ItemProperties.create().maxStackSize(1));
        this.type = type;
    }

    public BaseItem.ItemUseResult interact(ItemStack stack, Player player, InteractionHand hand, Level level) {
        if (!player.isCrouching()) {
            if (!level.isClientSide && stack.getItem() instanceof BackpackItem) {
                int bagSlot = hand == InteractionHand.MAIN_HAND ? player.getInventory().getSelectedSlot() : -1;
                PackedUpCommon.openBackpackInventory(stack, player, bagSlot);
            }
        } else if (level.isClientSide) {
            PackedUpClient.openBackpackRenameScreen(hand);
        }
        return BaseItem.ItemUseResult.success((ItemStack)stack);
    }

    protected void appendItemInformation(ItemStack stack, Consumer<Component> info, boolean advanced) {
        info.accept((Component)TextComponents.translation((String)"packedup.backpacks.info.one", (Object[])new Object[]{TextComponents.string((String)Integer.toString(this.type.getSlots())).color(ChatFormatting.GOLD).get()}).color(ChatFormatting.AQUA).get());
        Component key = PackedUpClient.getKeyBindCharacter();
        if (key != null) {
            info.accept((Component)TextComponents.translation((String)"packedup.backpacks.info.two", (Object[])new Object[]{key}).color(ChatFormatting.AQUA).get());
        }
        if (advanced && stack.has(INVENTORY_ID)) {
            info.accept((Component)TextComponents.translation((String)"packedup.backpacks.info.inventory_index", (Object[])new Object[]{stack.get(INVENTORY_ID)}).get());
        }
        super.appendItemInformation(stack, info, advanced);
    }

    public boolean isInCreativeGroup(CreativeModeTab tab) {
        return this.type.isEnabled() && super.isInCreativeGroup(tab);
    }

    private record Icon(ItemStack stack) {
        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Icon)) {
                return false;
            }
            Icon icon = (Icon)o;
            return ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)icon.stack);
        }

        @Override
        public int hashCode() {
            return ItemStack.hashItemAndComponents((ItemStack)this.stack);
        }
    }
}

