/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.MapCodec;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.packedup.BackpackItem;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BackpackIconRenderer
implements ItemModel.Unbaked {
    public static final MapCodec<BackpackIconRenderer> CODEC = MapCodec.unit((Object)new BackpackIconRenderer());
    private static final SpecialModelRenderer<ItemStack> ICON_RENDERER = new SpecialModelRenderer<ItemStack>(){
        private static final ThreadLocal<Boolean> RECURSION_GUARD = ThreadLocal.withInitial(() -> false);

        public void render(ItemStack icon, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay, boolean hasFoil) {
            RECURSION_GUARD.set(true);
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.4f, 1.0f);
            poseStack.scale(0.7f, 0.7f, 0.7f);
            ClientUtils.getItemRenderer().renderStatic(icon, ItemDisplayContext.GUI, combinedLight, combinedOverlay, poseStack, bufferSource, null, 0);
            poseStack.popPose();
            RECURSION_GUARD.remove();
        }

        public void getExtents(Set<Vector3f> set) {
        }

        @Nullable
        public ItemStack extractArgument(ItemStack stack) {
            return null;
        }
    };

    public MapCodec<? extends ItemModel.Unbaked> type() {
        return CODEC;
    }

    public ItemModel bake(ItemModel.BakingContext context) {
        return (renderState, stack, modelResolver, transformType, level, entity, someRandomId) -> {
            renderState.appendModelIdentityElement((Object)this);
            if (transformType != ItemDisplayContext.GUI) {
                return;
            }
            ItemStack icon = BackpackItem.getIcon(stack);
            if (!icon.isEmpty()) {
                renderState.newLayer().setupSpecialModel(ICON_RENDERER, (Object)icon);
                renderState.appendModelIdentityElement((Object)icon.getItem());
            }
        };
    }

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
    }
}

