/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.packet;

import com.supermartijn642.core.network.BlockEntityBasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.trashcans.TrashCanBlockEntity;
import com.supermartijn642.trashcans.filter.ItemFilter;
import com.supermartijn642.trashcans.filter.LiquidTrashCanFilters;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;

public class PacketChangeLiquidFilter
extends BlockEntityBasePacket<TrashCanBlockEntity> {
    private int filterSlot;
    private ItemFilter filter;

    public PacketChangeLiquidFilter(BlockPos pos, int filterSlot, ItemFilter filter) {
        super(pos);
        this.filterSlot = filterSlot;
        this.filter = filter;
    }

    public PacketChangeLiquidFilter() {
    }

    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeInt(this.filterSlot);
        TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)((RegistryFriendlyByteBuf)buffer).registryAccess());
        LiquidTrashCanFilters.write(this.filter, (ValueOutput)output);
        buffer.writeNbt((Tag)output.buildResult());
    }

    public void read(FriendlyByteBuf buffer) {
        super.read(buffer);
        this.filterSlot = buffer.readInt();
        this.filter = LiquidTrashCanFilters.read(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)((RegistryFriendlyByteBuf)buffer).registryAccess(), (CompoundTag)buffer.readNbt()));
    }

    public boolean verify(PacketContext context) {
        return this.filterSlot >= 0 && this.filterSlot < 9;
    }

    protected void handle(TrashCanBlockEntity entity, PacketContext context) {
        if (entity.liquids) {
            entity.liquidFilter.set(this.filterSlot, this.filter);
            entity.dataChanged();
        }
    }
}

