/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.filter;

import com.supermartijn642.trashcans.filter.IFilterManager;
import com.supermartijn642.trashcans.filter.ItemFilter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;

public class FluidFilterManager
implements IFilterManager {
    @Override
    public ItemFilter createFilter(ItemStack stack) {
        return new FluidFilter(stack);
    }

    @Override
    public ItemFilter readFilter(ValueInput input) {
        return new FluidFilter(input);
    }

    private static class FluidFilter
    extends ItemFilter {
        FluidStack stack;

        public FluidFilter(ItemStack stack) {
            this.stack = FluidFilter.getFluid(stack);
            if (this.stack != null) {
                this.stack = this.stack.copy();
            }
        }

        public FluidFilter(ValueInput input) {
            this.stack = input.read("stack", FluidStack.CODEC).orElse(FluidStack.EMPTY);
        }

        @Override
        public boolean matches(Object stack) {
            FluidStack fluid = stack instanceof FluidStack ? (FluidStack)stack : (stack instanceof ItemStack ? FluidFilter.getFluid((ItemStack)stack) : null);
            return fluid != null && fluid.isFluidEqual(this.stack);
        }

        @Override
        public ItemStack getRepresentingItem() {
            return new ItemStack((ItemLike)this.stack.getFluid().getBucket());
        }

        @Override
        public void write(ValueOutput output) {
            output.store("stack", FluidStack.CODEC, (Object)this.stack);
        }

        @Override
        public boolean isValid() {
            return this.stack != null && !this.stack.isEmpty();
        }

        private static FluidStack getFluid(ItemStack stack) {
            LazyOptional fluidHandler = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            return fluidHandler.filter(h -> h.getTanks() == 1).map(h -> h.getFluidInTank(0)).filter(f -> !f.isEmpty()).orElse(null);
        }
    }
}

