/*
 * Decompiled with CFR 0.152.
 */
package glitchcore.mixin;

import glitchcore.event.EventManager;
import glitchcore.event.entity.LivingEntityUseItemEvent;
import glitchcore.event.player.PlayerInteractEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class MixinItemStack {
    @Unique
    private ItemStack finishUsingItemCopy;

    @Shadow
    public abstract ItemStack copy();

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void onUse(Level level, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        PlayerInteractEvent.UseItem event = new PlayerInteractEvent.UseItem(player, hand);
        EventManager.fire(event);
        if (event.isCancelled()) {
            cir.setReturnValue((Object)event.getCancelResult());
        }
    }

    @Inject(method={"finishUsingItem"}, at={@At(value="HEAD")})
    public void onFinishUsingItemBegin(Level level, LivingEntity entity, CallbackInfoReturnable<ItemStack> cir) {
        this.finishUsingItemCopy = this.copy();
    }

    @Inject(method={"finishUsingItem"}, at={@At(value="TAIL")}, cancellable=true)
    public void onFinishUsingItem(Level level, LivingEntity entity, CallbackInfoReturnable<ItemStack> cir) {
        LivingEntityUseItemEvent.Finish event = new LivingEntityUseItemEvent.Finish(entity, this.finishUsingItemCopy, (ItemStack)cir.getReturnValue());
        EventManager.fire(event);
        cir.setReturnValue((Object)event.getResult());
    }
}

