/*
 * Decompiled with CFR 0.152.
 */
package com.texelsaurus.minecraft.chameleon.service;

import com.jaquadro.minecraft.storagedrawers.client.ClientUtil;
import com.texelsaurus.minecraft.chameleon.api.ChameleonInit;
import com.texelsaurus.minecraft.chameleon.network.ChameleonPacket;
import com.texelsaurus.minecraft.chameleon.service.ChameleonNetworking;
import java.util.function.BiConsumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.payload.PayloadFlow;
import net.minecraftforge.network.payload.PayloadProtocol;

public class ForgeNetworking
implements ChameleonNetworking {
    public static PayloadProtocol<RegistryFriendlyByteBuf, CustomPacketPayload> NETWORK_CHANNEL_BUILDER = ChannelBuilder.named((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"storagedrawers", (String)"main")).networkProtocolVersion(1).optional().payloadChannel().play();
    public static Channel<CustomPacketPayload> CHANNEL;

    public static void init(ChameleonInit init, ChameleonInit.InitContext context) {
        init.init(context);
        CHANNEL = ((PayloadFlow)NETWORK_CHANNEL_BUILDER.bidirectional()).build();
    }

    @Override
    public <B extends FriendlyByteBuf, P extends ChameleonPacket> void registerPacketInternal(CustomPacketPayload.Type<P> payloadType, StreamCodec<B, P> codec, boolean clientBound) {
        BiConsumer<ChameleonPacket, CustomPayloadEvent.Context> handler = (packet, context) -> {
            ServerPlayer player = context.getSender();
            if (player == null && context.isClientSide()) {
                player = ClientUtil.getLocalPlayer();
            }
            packet.handleMessage((Player)player, arg_0 -> ((CustomPayloadEvent.Context)context).enqueueWork(arg_0));
            context.setPacketHandled(true);
        };
        if (clientBound) {
            ((PayloadFlow)NETWORK_CHANNEL_BUILDER.clientbound()).add(payloadType, codec, handler);
        } else {
            ((PayloadFlow)NETWORK_CHANNEL_BUILDER.serverbound()).add(payloadType, codec, handler);
        }
    }

    @Override
    public void sendToPlayer(ChameleonPacket packet, ServerPlayer player) {
        CHANNEL.send((Object)packet, PacketDistributor.PLAYER.with((Object)player));
    }

    @Override
    public void sendToPlayersNear(ChameleonPacket packet, ServerLevel level, double x, double y, double z, double radius) {
        CHANNEL.send((Object)packet, PacketDistributor.NEAR.with((Object)new PacketDistributor.TargetPoint(x, y, z, radius, level.dimension())));
    }

    @Override
    public void sendToServer(ChameleonPacket packet) {
        CHANNEL.send((Object)packet, PacketDistributor.SERVER.noArg());
    }
}

