/*
 * Decompiled with CFR 0.152.
 */
package com.texelsaurus.minecraft.chameleon.service;

import com.texelsaurus.minecraft.chameleon.capabilities.ChameleonCapability;
import com.texelsaurus.minecraft.chameleon.capabilities.ForgeCapability;
import com.texelsaurus.minecraft.chameleon.capabilities.IForgeCapability;
import com.texelsaurus.minecraft.chameleon.service.ChameleonCapabilities;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ForgeCapabilities
implements ChameleonCapabilities {
    private static Map<ResourceLocation, IForgeCapability> capabilties = new HashMap<ResourceLocation, IForgeCapability>();

    @Override
    public <T, C> ChameleonCapability<T> create(ResourceLocation location, Class<T> clazz, Class<C> context) {
        return new DeferredCapability(this, location);
    }

    public static <T> void reigsterCapability(ForgeCapability<T> capability) {
        capabilties.put(capability.id(), capability);
    }

    private class DeferredCapability<T>
    implements IForgeCapability<T> {
        private ResourceLocation id;
        private IForgeCapability<T> cap;

        public DeferredCapability(ForgeCapabilities forgeCapabilities, ResourceLocation id) {
            this.id = id;
        }

        @Override
        public ResourceLocation id() {
            return this.id;
        }

        @Override
        public T getCapability(Level level, BlockPos pos) {
            if (this.cap != null) {
                return this.cap.getCapability(level, pos);
            }
            this.cap = capabilties.getOrDefault(this.id, null);
            if (this.cap != null) {
                return this.cap.getCapability(level, pos);
            }
            return null;
        }

        @Override
        public <BE extends BlockEntity> T getCapability(BE blockEntity) {
            if (this.cap != null) {
                return this.cap.getCapability(blockEntity);
            }
            this.cap = capabilties.getOrDefault(this.id, null);
            if (this.cap != null) {
                return this.cap.getCapability(blockEntity);
            }
            return null;
        }

        @Override
        public <BE extends BlockEntity> void register(BlockEntityType<BE> entity, Function<BE, T> provider) {
            if (this.cap == null) {
                this.cap = capabilties.getOrDefault(this.id, null);
            }
            if (this.cap != null) {
                this.cap.register(entity, provider);
            }
        }
    }
}

