/*
 * Decompiled with CFR 0.152.
 */
package com.texelsaurus.minecraft.chameleon.capabilities;

import com.texelsaurus.minecraft.chameleon.capabilities.IForgeCapability;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.capabilities.Capability;

public class ForgeCapability<T>
implements IForgeCapability<T> {
    final ResourceLocation id;
    final Capability<T> nativeCapability;
    final Map<BlockEntityType<?>, Function<BlockEntity, T>> handlers = new HashMap();

    public ForgeCapability(ResourceLocation id, Capability<T> nativeCapability) {
        this.id = id;
        this.nativeCapability = nativeCapability;
    }

    @Override
    public ResourceLocation id() {
        return this.id;
    }

    @Override
    public T getCapability(Level level, BlockPos pos) {
        return this.getCapability(level.getBlockEntity(pos));
    }

    @Override
    public <BE extends BlockEntity> T getCapability(BE blockEntity) {
        if (blockEntity == null) {
            return null;
        }
        BlockEntityType type = blockEntity.getType();
        if (!this.handlers.containsKey(type)) {
            return null;
        }
        return this.handlers.get(type).apply(blockEntity);
    }

    @Override
    public <BE extends BlockEntity> void register(BlockEntityType<BE> entity, Function<BE, T> provider) {
        this.handlers.put(entity, provider);
    }
}

