/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.capabilities.Capabilities;
import com.jaquadro.minecraft.storagedrawers.util.ComponentUtil;
import com.texelsaurus.minecraft.chameleon.util.WorldUtils;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ItemKey
extends Item {
    public ItemKey(Item.Properties properties) {
        super(properties.attributes(ItemKey.createAttributes()));
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public boolean canDestroyBlock(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !player.isCreative();
        }
        return super.canDestroyBlock(stack, state, level, pos, entity);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, display, tooltip, flag);
        ComponentUtil.appendSplitDescription(tooltip, this.getDescription());
    }

    @NotNull
    public Component getDescription() {
        return Component.translatable((String)(this.getDescriptionId() + ".desc"));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockEntity = WorldUtils.getBlockEntity((BlockGetter)context.getLevel(), context.getClickedPos(), BlockEntity.class);
        if (blockEntity == null) {
            return InteractionResult.PASS;
        }
        IDrawerAttributes attrs = Capabilities.DRAWER_ATTRIBUTES.getCapability(blockEntity.getLevel(), blockEntity.getBlockPos());
        if (attrs == null) {
            attrs = EmptyDrawerAttributes.EMPTY;
        }
        if (!(attrs instanceof IDrawerAttributesModifiable)) {
            return InteractionResult.PASS;
        }
        this.handleDrawerAttributes((IDrawerAttributesModifiable)attrs);
        return InteractionResult.SUCCESS;
    }

    protected void handleDrawerAttributes(IDrawerAttributesModifiable attrs) {
    }
}

