/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import com.jaquadro.minecraft.storagedrawers.block.framed.BlockFramedStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.framed.BlockFramedTrim;
import com.jaquadro.minecraft.storagedrawers.block.meta.BlockMeta;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeRedstone;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeStorage;
import com.jaquadro.minecraft.storagedrawers.item.ItemDetachedDrawer;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawerKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawerPuller;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemFramedDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemFramedTrim;
import com.jaquadro.minecraft.storagedrawers.item.ItemKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemKeyring;
import com.jaquadro.minecraft.storagedrawers.item.ItemPersonalKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemPriorityKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemQuantifyKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemShroudKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemTrim;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeBalance;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeFillLevel;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeIllumination;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradePortability;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRedstone;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRemote;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeVoid;
import com.texelsaurus.minecraft.chameleon.ChameleonServices;
import com.texelsaurus.minecraft.chameleon.api.ChameleonInit;
import com.texelsaurus.minecraft.chameleon.registry.ChameleonRegistry;
import com.texelsaurus.minecraft.chameleon.registry.RegistryEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public final class ModItems {
    public static final ChameleonRegistry<Item> ITEMS = ChameleonServices.REGISTRY.create(BuiltInRegistries.ITEM, "storagedrawers");
    public static final List<RegistryEntry<? extends Item>> EXCLUDE_ITEMS_CREATIVE_TAB = new ArrayList<RegistryEntry<? extends Item>>();
    public static final RegistryEntry<? extends Item> OBSIDIAN_STORAGE_UPGRADE = ModItems.register("obsidian_storage_upgrade", p -> new ItemUpgradeStorage(EnumUpgradeStorage.OBSIDIAN, (Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> IRON_STORAGE_UPGRADE = ModItems.register("iron_storage_upgrade", p -> new ItemUpgradeStorage(EnumUpgradeStorage.IRON, (Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> GOLD_STORAGE_UPGRADE = ModItems.register("gold_storage_upgrade", p -> new ItemUpgradeStorage(EnumUpgradeStorage.GOLD, (Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> DIAMOND_STORAGE_UPGRADE = ModItems.register("diamond_storage_upgrade", p -> new ItemUpgradeStorage(EnumUpgradeStorage.DIAMOND, (Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> EMERALD_STORAGE_UPGRADE = ModItems.register("emerald_storage_upgrade", p -> new ItemUpgradeStorage(EnumUpgradeStorage.EMERALD, (Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> ONE_STACK_UPGRADE = ModItems.register("one_stack_upgrade", p -> new ItemUpgrade((Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> VOID_UPGRADE = ModItems.register("void_upgrade", p -> new ItemUpgradeVoid((Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> CREATIVE_STORAGE_UPGRADE = ModItems.register("creative_storage_upgrade", p -> new ItemUpgrade((Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> CREATIVE_VENDING_UPGRADE = ModItems.register("creative_vending_upgrade", p -> new ItemUpgrade((Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> CONVERSION_UPGRADE = ModItems.register("conversion_upgrade", p -> new ItemUpgrade((Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> REDSTONE_UPGRADE = ModItems.register("redstone_upgrade", p -> new ItemUpgradeRedstone(EnumUpgradeRedstone.COMBINED, (Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> MIN_REDSTONE_UPGRADE = ModItems.register("min_redstone_upgrade", p -> new ItemUpgradeRedstone(EnumUpgradeRedstone.MIN, (Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> MAX_REDSTONE_UPGRADE = ModItems.register("max_redstone_upgrade", p -> new ItemUpgradeRedstone(EnumUpgradeRedstone.MAX, (Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> ILLUMINATION_UPGRADE = ModItems.register("illumination_upgrade", p -> new ItemUpgradeIllumination((Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> FILL_LEVEL_UPGRADE = ModItems.register("fill_level_upgrade", p -> new ItemUpgradeFillLevel((Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> BALANCE_FILL_UPGRADE = ModItems.register("balance_fill_upgrade", p -> new ItemUpgradeBalance((Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> PORTABILITY_UPGRADE = ModItems.register("portability_upgrade", p -> new ItemUpgradePortability((Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> REMOTE_UPGRADE = ModItems.register("remote_upgrade", p -> new ItemUpgradeRemote(false, false, (Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> REMOTE_UPGRADE_BOUND = ModItems.register("remote_upgrade_bound", p -> new ItemUpgradeRemote(false, true, (Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> REMOTE_GROUP_UPGRADE = ModItems.register("remote_group_upgrade", p -> new ItemUpgradeRemote(true, false, (Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> REMOTE_GROUP_UPGRADE_BOUND = ModItems.register("remote_group_upgrade_bound", p -> new ItemUpgradeRemote(true, true, (Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> UPGRADE_TEMPLATE = ModItems.register("upgrade_template", p -> new Item(p), new Item.Properties());
    public static final RegistryEntry<? extends Item> DETACHED_DRAWER = ModItems.register("detached_drawer", p -> new ItemDetachedDrawer((Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends Item> DETACHED_DRAWER_FULL = ModItems.register("detached_drawer_full", p -> new ItemDetachedDrawer((Item.Properties)p), new Item.Properties().stacksTo(1).overrideDescription("item.storagedrawers.detached_drawer"));
    public static final RegistryEntry<? extends ItemKey> DRAWER_KEY = ModItems.register("drawer_key", p -> new ItemDrawerKey((Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends ItemKey> QUANTIFY_KEY = ModItems.register("quantify_key", p -> new ItemQuantifyKey((Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends ItemKey> SHROUD_KEY = ModItems.register("shroud_key", p -> new ItemShroudKey((Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends ItemKey> PERSONAL_KEY = ModItems.register("personal_key", p -> new ItemPersonalKey(null, (Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends ItemKey> PERSONAL_KEY_COFH = ModItems.register("personal_key_cofh", p -> new ItemPersonalKey("cofh", (Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends ItemKey> PRIORITY_KEY = ModItems.register("priority_key", p -> new ItemPriorityKey(0, 1, (Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends ItemKey> PRIORITY_KEY_P1 = ModItems.register("priority_key_p1", p -> new ItemPriorityKey(1, 2, (Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends ItemKey> PRIORITY_KEY_P2 = ModItems.register("priority_key_p2", p -> new ItemPriorityKey(2, -1, (Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends ItemKey> PRIORITY_KEY_N1 = ModItems.register("priority_key_n1", p -> new ItemPriorityKey(-1, -2, (Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends ItemKey> PRIORITY_KEY_N2 = ModItems.register("priority_key_n2", p -> new ItemPriorityKey(-2, 0, (Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends ItemKey> DRAWER_PULLER = ModItems.register("drawer_puller", p -> new ItemDrawerPuller((Item.Properties)p), new Item.Properties());
    public static final RegistryEntry<? extends ItemKeyring> KEYRING = ModItems.register("keyring", p -> new ItemKeyring(null, (Item.Properties)p), new Item.Properties().stacksTo(1));
    public static final RegistryEntry<? extends ItemKeyring> KEYRING_DRAWER = ModItems.register("keyring_drawer", p -> new ItemKeyring(DRAWER_KEY, (Item.Properties)p), new Item.Properties().stacksTo(1));
    public static final RegistryEntry<? extends ItemKeyring> KEYRING_QUANTIFY = ModItems.register("keyring_quantify", p -> new ItemKeyring(QUANTIFY_KEY, (Item.Properties)p), new Item.Properties().stacksTo(1));
    public static final RegistryEntry<? extends ItemKeyring> KEYRING_SHROUD = ModItems.register("keyring_shroud", p -> new ItemKeyring(SHROUD_KEY, (Item.Properties)p), new Item.Properties().stacksTo(1));
    public static final RegistryEntry<? extends ItemKeyring> KEYRING_PERSONAL = ModItems.register("keyring_personal", p -> new ItemKeyring(PERSONAL_KEY, (Item.Properties)p), new Item.Properties().stacksTo(1));
    public static final RegistryEntry<? extends ItemKeyring> KEYRING_PERSONAL_COFH = ModItems.register("keyring_personal_cofh", p -> new ItemKeyring(PERSONAL_KEY_COFH, (Item.Properties)p), new Item.Properties().stacksTo(1));
    public static final RegistryEntry<? extends ItemKeyring> KEYRING_PRIORITY = ModItems.register("keyring_priority", p -> new ItemKeyring(PRIORITY_KEY, (Item.Properties)p), new Item.Properties().stacksTo(1));
    public static final RegistryEntry<? extends ItemKeyring> KEYRING_PRIORITY_P1 = ModItems.register("keyring_priority_p1", p -> new ItemKeyring(PRIORITY_KEY_P1, (Item.Properties)p), new Item.Properties().stacksTo(1));
    public static final RegistryEntry<? extends ItemKeyring> KEYRING_PRIORITY_P2 = ModItems.register("keyring_priority_p2", p -> new ItemKeyring(PRIORITY_KEY_P2, (Item.Properties)p), new Item.Properties().stacksTo(1));
    public static final RegistryEntry<? extends ItemKeyring> KEYRING_PRIORITY_N1 = ModItems.register("keyring_priority_n1", p -> new ItemKeyring(PRIORITY_KEY_N1, (Item.Properties)p), new Item.Properties().stacksTo(1));
    public static final RegistryEntry<? extends ItemKeyring> KEYRING_PRIORITY_N2 = ModItems.register("keyring_priority_n2", p -> new ItemKeyring(PRIORITY_KEY_N2, (Item.Properties)p), new Item.Properties().stacksTo(1));
    public static final RegistryEntry<? extends ItemKeyring> KEYRING_PULLER = ModItems.register("keyring_puller", p -> new ItemKeyring(DRAWER_PULLER, (Item.Properties)p), new Item.Properties().stacksTo(1));

    private static <C extends Item> RegistryEntry<C> register(String name, Function<Item.Properties, C> supplier, Item.Properties props) {
        return ITEMS.register(name, () -> (Item)supplier.apply(props.setId(ModItems.modKey(name))));
    }

    private ModItems() {
    }

    public static void init(ChameleonInit.InitContext context) {
        EXCLUDE_ITEMS_CREATIVE_TAB.add(PRIORITY_KEY_N1);
        EXCLUDE_ITEMS_CREATIVE_TAB.add(PRIORITY_KEY_N2);
        EXCLUDE_ITEMS_CREATIVE_TAB.add(PRIORITY_KEY_P1);
        EXCLUDE_ITEMS_CREATIVE_TAB.add(PRIORITY_KEY_P2);
        EXCLUDE_ITEMS_CREATIVE_TAB.add(KEYRING_DRAWER);
        EXCLUDE_ITEMS_CREATIVE_TAB.add(KEYRING_QUANTIFY);
        EXCLUDE_ITEMS_CREATIVE_TAB.add(KEYRING_SHROUD);
        EXCLUDE_ITEMS_CREATIVE_TAB.add(KEYRING_PERSONAL);
        EXCLUDE_ITEMS_CREATIVE_TAB.add(KEYRING_PERSONAL_COFH);
        EXCLUDE_ITEMS_CREATIVE_TAB.add(KEYRING_PRIORITY);
        EXCLUDE_ITEMS_CREATIVE_TAB.add(KEYRING_PRIORITY_P1);
        EXCLUDE_ITEMS_CREATIVE_TAB.add(KEYRING_PRIORITY_P2);
        EXCLUDE_ITEMS_CREATIVE_TAB.add(KEYRING_PRIORITY_N1);
        EXCLUDE_ITEMS_CREATIVE_TAB.add(KEYRING_PRIORITY_N2);
        EXCLUDE_ITEMS_CREATIVE_TAB.add(KEYRING_PULLER);
        EXCLUDE_ITEMS_CREATIVE_TAB.add(DETACHED_DRAWER_FULL);
        EXCLUDE_ITEMS_CREATIVE_TAB.add(REMOTE_UPGRADE_BOUND);
        EXCLUDE_ITEMS_CREATIVE_TAB.add(REMOTE_GROUP_UPGRADE_BOUND);
        for (RegistryEntry<Block> ro : ModBlocks.BLOCKS.getEntries()) {
            if (ModBlocks.EXCLUDE_ITEMS.contains(ro.getId().getPath())) continue;
            ModItems.registerBlock(ITEMS, ro);
        }
        ITEMS.init(context);
    }

    static ResourceLocation modLoc(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"storagedrawers", (String)name);
    }

    static ResourceKey<Item> modKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ModItems.modLoc(name));
    }

    static ResourceKey<Item> modKey(ResourceLocation name) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)name);
    }

    static void registerBlock(ChameleonRegistry<Item> register, RegistryEntry<? extends Block> blockHolder) {
        if (blockHolder == null) {
            return;
        }
        register.register(blockHolder.getId().getPath(), () -> {
            Block block = (Block)blockHolder.get();
            Item.Properties itemProperties = new Item.Properties().useBlockDescriptionPrefix().setId(ModItems.modKey(blockHolder.getId()));
            if (block instanceof BlockMeta) {
                return null;
            }
            if (block instanceof BlockFramedStandardDrawers) {
                return new ItemFramedDrawers(block, itemProperties);
            }
            if (block instanceof BlockDrawers) {
                return new ItemDrawers(block, itemProperties);
            }
            if (block instanceof BlockFramedTrim) {
                return new ItemFramedTrim(block, itemProperties);
            }
            if (block instanceof BlockTrim) {
                return new ItemTrim(block, itemProperties);
            }
            return new BlockItem(block, itemProperties);
        });
    }

    private static <B extends Item> Stream<B> getItemsOfType(Class<B> itemClass) {
        return BuiltInRegistries.ITEM.stream().filter(itemClass::isInstance).map(itemClass::cast);
    }

    public static Stream<ItemKey> getKeys() {
        return ModItems.getItemsOfType(ItemKey.class);
    }

    public static Stream<ItemKeyring> getKeyrings() {
        return ModItems.getItemsOfType(ItemKeyring.class);
    }
}

