/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import com.texelsaurus.minecraft.chameleon.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ItemStackedOnOtherEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="storagedrawers")
public class CommonEventBusSubscriber {
    @SubscribeEvent
    public static boolean playerLeftClick(@NotNull PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof BlockDrawers) {
            BlockHitResult hit;
            BlockDrawers blockDrawers = (BlockDrawers)block;
            Player player = event.getEntity();
            if (player.isCreative() && (hit = WorldUtils.rayTraceEyes(level, player, pos)).getType() == HitResult.Type.BLOCK) {
                blockDrawers.leftAction(state, level, pos, player, hit);
                if (blockDrawers.getFaceSlot(state, hit) >= 0) {
                    return true;
                }
            }
        }
        return false;
    }

    @SubscribeEvent
    public static boolean itemStackedOn(ItemStackedOnOtherEvent event) {
        if (!(event.getStackedOnItem().getItem() instanceof ItemUpgradeStorage)) {
            return false;
        }
        if (!(event.getCarriedItem().getItem() instanceof ItemUpgradeStorage)) {
            return false;
        }
        Slot slot = event.getSlot();
        if (slot instanceof SlotUpgrade) {
            SlotUpgrade slot2 = (SlotUpgrade)slot;
            ItemStack stacked = event.getStackedOnItem();
            ItemStack carried = event.getCarriedItem();
            ItemStack slotStack = event.getSlot().getItem();
            if (ItemStack.matches((ItemStack)slotStack, (ItemStack)carried) && !ItemStack.matches((ItemStack)slotStack, (ItemStack)stacked)) {
                carried = event.getStackedOnItem();
                stacked = event.getCarriedItem();
            }
            if (slot2.canSwapStack(carried)) {
                event.getSlot().set(carried);
                event.getCarriedSlotAccess().set(stacked);
                return true;
            }
        }
        return false;
    }
}

