/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.client.model.ParentModel;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpriteReplacementModel
extends ParentModel {
    private TextureAtlasSprite sprite;
    private Map<BlockModelPart, ReplacementBlockPart> cache = new HashMap<BlockModelPart, ReplacementBlockPart>();

    public SpriteReplacementModel(@NotNull BlockStateModel parent, TextureAtlasSprite sprite) {
        super(parent);
        this.sprite = sprite;
    }

    public SpriteReplacementModel(@NotNull BlockStateModel parent, ItemStack stack) {
        super(parent);
        Item item;
        if (stack != null && (item = stack.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            BlockRenderDispatcher disp = Minecraft.getInstance().getBlockRenderer();
            BlockStateModel model = disp.getBlockModel(block.defaultBlockState());
            this.sprite = model.particleIcon();
        }
    }

    @Override
    public void collectParts(RandomSource randomSource, List<BlockModelPart> list) {
        if (this.sprite == null) {
            super.collectParts(randomSource, list);
            return;
        }
        this.parent.collectParts(randomSource).forEach(part -> {
            if (this.cache.containsKey(part)) {
                list.add(this.cache.get(part));
            } else {
                ReplacementBlockPart replacement = new ReplacementBlockPart((BlockModelPart)part, this.sprite);
                if (this.cache.size() < 10) {
                    this.cache.put((BlockModelPart)part, replacement);
                }
                list.add(replacement);
            }
        });
    }

    @Override
    public TextureAtlasSprite particleIcon() {
        if (this.sprite == null) {
            return super.particleIcon();
        }
        return this.sprite;
    }

    private static class ReplacementBlockPart
    implements BlockModelPart {
        private BlockModelPart parent;
        private TextureAtlasSprite sprite;
        private List<BakedQuad> quads = new ArrayList<BakedQuad>();

        public ReplacementBlockPart(BlockModelPart part, TextureAtlasSprite sprite) {
            this.parent = part;
            this.sprite = sprite;
            part.getQuads(null).forEach(quad -> this.quads.add(this.remapQuad((BakedQuad)quad, sprite)));
            for (Direction dir : Direction.values()) {
                part.getQuads(dir).forEach(quad -> this.quads.add(this.remapQuad((BakedQuad)quad, sprite)));
            }
        }

        public List<BakedQuad> getQuads(@Nullable Direction direction) {
            return this.quads;
        }

        public boolean useAmbientOcclusion() {
            return this.parent.useAmbientOcclusion();
        }

        public TextureAtlasSprite particleIcon() {
            if (this.sprite == null) {
                return this.parent.particleIcon();
            }
            return this.sprite;
        }

        BakedQuad remapQuad(BakedQuad quad, TextureAtlasSprite sprite) {
            int[] vertices = (int[])quad.vertices().clone();
            for (int i = 0; i < 4; ++i) {
                int blk = DefaultVertexFormat.BLOCK.getVertexSize() / 4 * i;
                int offset = DefaultVertexFormat.BLOCK.getOffset(VertexFormatElement.UV) / 4;
                vertices[blk + offset] = Float.floatToRawIntBits(sprite.getU(this.getUnInterpolatedU(quad.sprite(), Float.intBitsToFloat(vertices[blk + offset]))));
                vertices[blk + offset + 1] = Float.floatToRawIntBits(sprite.getV(this.getUnInterpolatedV(quad.sprite(), Float.intBitsToFloat(vertices[blk + offset + 1]))));
            }
            return new BakedQuad(vertices, quad.tintIndex(), quad.direction(), sprite, quad.shade(), quad.lightEmission());
        }

        private float getUnInterpolatedU(TextureAtlasSprite sprite, float u) {
            float diff = sprite.getU1() - sprite.getU0();
            return (u - sprite.getU0()) / diff;
        }

        private float getUnInterpolatedV(TextureAtlasSprite sprite, float v) {
            float diff = sprite.getV1() - sprite.getV0();
            return (v - sprite.getV0()) / diff;
        }
    }
}

