/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.gui;

import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageGuiGraphics
extends GuiGraphics {
    private final Minecraft minecraft;
    @NotNull
    public ItemStack overrideStack;

    public StorageGuiGraphics(Minecraft minecraft, GuiRenderState renderState) {
        super(minecraft, renderState);
        this.minecraft = minecraft;
        this.overrideStack = ItemStack.EMPTY;
    }

    public void renderItemDecorations(Font font, ItemStack item, int x, int y, @Nullable String text) {
        if (item != this.overrideStack) {
            super.renderItemDecorations(font, item, x, y, text);
            return;
        }
        if (!item.isEmpty()) {
            this.pose().pushMatrix();
            this.renderItemBar(item, x, y);
            this.renderItemCooldown(item, x, y);
            this.renderItemCount(font, item, x, y, text);
            this.pose().popMatrix();
        }
    }

    private void renderItemBar(ItemStack stack, int x, int y) {
        if (stack.isBarVisible()) {
            int offX = x + 2;
            int offY = y + 13;
            this.fill(RenderPipelines.GUI, offX, offY, offX + 13, offY + 2, -16777216);
            this.fill(RenderPipelines.GUI, offX, offY, offX + stack.getBarWidth(), offY + 1, ARGB.opaque((int)stack.getBarColor()));
        }
    }

    private void renderItemCooldown(ItemStack stack, int x, int y) {
        float f;
        LocalPlayer player = this.minecraft.player;
        float f2 = f = player == null ? 0.0f : player.getCooldowns().getCooldownPercent(stack, this.minecraft.getDeltaTracker().getGameTimeDeltaPartialTick(true));
        if (f > 0.0f) {
            int y1 = y + Mth.floor((float)(16.0f * (1.0f - f)));
            int y2 = y1 + Mth.ceil((float)(16.0f * f));
            this.fill(RenderPipelines.GUI, x, y1, x + 16, y2, Integer.MAX_VALUE);
        }
    }

    private void renderItemCount(Font font, ItemStack stack, int x, int y, String text) {
        stack = ItemStackHelper.decodeItemStack(stack);
        int stackSize = stack.getCount();
        float scale = 0.5f;
        if (stackSize >= 0 || text != null) {
            text = stackSize >= 100000000 ? (text == null ? String.format("%.0fM", Float.valueOf((float)stackSize / 1000000.0f)) : text) : (stackSize >= 1000000 ? (text == null ? String.format("%.1fM", Float.valueOf((float)stackSize / 1000000.0f)) : text) : (stackSize >= 100000 ? (text == null ? String.format("%.0fK", Float.valueOf((float)stackSize / 1000.0f)) : text) : (stackSize >= 10000 ? (text == null ? String.format("%.1fK", Float.valueOf((float)stackSize / 1000.0f)) : text) : (text == null ? String.valueOf(stackSize) : text))));
            int textX = (int)(((float)(x + 16) - (float)font.width(text) * scale) / scale) - 1;
            int textY = (int)(((float)(y + 16) - 7.0f * scale) / scale) - 1;
            int color = -1;
            if (stackSize == 0) {
                color = 0xFF6060;
            }
            this.pose().pushMatrix();
            this.pose().scale(scale, scale);
            this.drawString(font, text, textX, textY, color, true);
            this.pose().popMatrix();
        }
    }
}

