/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.gui;

import com.jaquadro.minecraft.storagedrawers.ModConstants;
import com.jaquadro.minecraft.storagedrawers.components.item.DetachedDrawerContents;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.util.CountFormatter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ClientDetachedDrawerTooltip
implements ClientTooltipComponent {
    private static final ResourceLocation BACKGROUND_SPRITE = ModConstants.loc("textures/gui/detached_tooltip.png");
    private final ItemStack item;
    private final int stackLimit;

    public ClientDetachedDrawerTooltip(DetachedDrawerContents tooltip) {
        this.item = tooltip.getItem();
        this.stackLimit = tooltip.getStackLimit();
    }

    public int getHeight(Font font) {
        return this.backgroundHeight() + 4;
    }

    public int getWidth(Font font) {
        return this.backgroundWidth();
    }

    private int backgroundWidth() {
        return 128;
    }

    private int backgroundHeight() {
        return 24;
    }

    public void renderImage(Font font, int pX, int pY, int pW, int pH, GuiGraphics graphics) {
        boolean forceCapCheck = (Boolean)ModCommonConfig.INSTANCE.GENERAL.forceDetachedDrawersMaxCapacityCheck.get();
        int bgY = forceCapCheck ? 0 : 24;
        graphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND_SPRITE, pX, pY, 0.0f, (float)bgY, this.backgroundWidth(), this.backgroundHeight(), 128, 64);
        this.renderSlot(pX + 3, pY + 3, graphics, font);
        String count = CountFormatter.formatApprox(font, this.item.getCount());
        graphics.drawString(font, count, pX + 22, pY + 8, 0x808080, false);
        if (forceCapCheck) {
            graphics.drawString(font, Integer.toString(this.stackLimit), pX + 83, pY + 8, 0x808080, false);
        }
    }

    private void renderSlot(int pX, int pY, GuiGraphics graphics, Font font) {
        ItemStack itemstack = this.item;
        graphics.renderItem(itemstack, pX + 1, pY + 1, 0);
    }
}

