/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import com.jaquadro.minecraft.storagedrawers.capabilities.Capabilities;
import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackMatcher;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackTagMatcher;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;

public abstract class StandardDrawerGroup
extends BlockEntityDataShim
implements IDrawerGroup {
    private final DrawerData[] slots;
    private final int[] order;

    public StandardDrawerGroup(int slotCount) {
        this.slots = new DrawerData[slotCount];
        for (int i = 0; i < slotCount; ++i) {
            this.slots[i] = this.createDrawer(i);
        }
        this.order = new int[slotCount];
        this.syncSlots();
    }

    @Override
    public int getDrawerCount() {
        return this.slots.length;
    }

    @Override
    @NotNull
    public IDrawer getDrawer(int slot) {
        if (slot < 0 || slot >= this.slots.length) {
            return Drawers.DISABLED;
        }
        return this.slots[slot];
    }

    @Override
    public int[] getAccessibleDrawerSlots() {
        return this.order;
    }

    @Override
    public void read(ValueInput input) {
        ValueInput.ValueInputList itemList = input.childrenListOrEmpty("Drawers");
        int i = 0;
        for (ValueInput item : itemList) {
            this.slots[i++].deserializeNBT(item);
        }
    }

    @Override
    public void write(ValueOutput output) {
        if (this.slots == null) {
            return;
        }
        ValueOutput.ValueOutputList itemList = output.childrenList("Drawers");
        for (DrawerData slot : this.slots) {
            slot.serializeNBT(itemList.addChild());
        }
    }

    @NotNull
    protected abstract DrawerData createDrawer(int var1);

    public void syncAttributes() {
        for (DrawerData drawer : this.slots) {
            drawer.syncAttributes();
        }
    }

    public void syncSlots() {
        IDrawer drawer;
        int i;
        int index = 0;
        for (i = 0; i < this.slots.length; ++i) {
            drawer = this.getDrawer(i);
            if (drawer.isEmpty()) continue;
            this.order[index++] = i;
        }
        if (index != this.slots.length) {
            for (i = 0; i < this.slots.length; ++i) {
                drawer = this.getDrawer(i);
                if (!drawer.isEnabled() || !drawer.isEmpty()) continue;
                this.order[index++] = i;
            }
        }
        if (index != this.slots.length) {
            for (i = 0; i < this.slots.length; ++i) {
                drawer = this.getDrawer(i);
                if (drawer.isEnabled()) continue;
                this.order[index++] = i;
            }
        }
    }

    public static class DrawerData
    implements IDrawer {
        protected IDrawerAttributes cachedAttrs;
        protected StandardDrawerGroup group;
        @NotNull
        private ItemStack protoStack;
        private int count;
        private ItemStackMatcher matcher;
        private boolean missing;

        public DrawerData(StandardDrawerGroup group) {
            this.group = group;
            this.protoStack = ItemStack.EMPTY;
            this.matcher = ItemStackMatcher.EMPTY;
            this.missing = false;
        }

        protected DrawerData(DrawerData data) {
            this(data.group);
            this.cachedAttrs = data.cachedAttrs;
            this.protoStack = data.protoStack;
            this.count = data.count;
            this.matcher = data.matcher;
        }

        @NotNull
        IDrawerAttributes getAttributes() {
            if (this.cachedAttrs != null) {
                return this.cachedAttrs;
            }
            this.cachedAttrs = this.group.getCapability(Capabilities.DRAWER_ATTRIBUTES);
            if (this.cachedAttrs != null) {
                return this.cachedAttrs;
            }
            return EmptyDrawerAttributes.EMPTY;
        }

        @Override
        @NotNull
        public ItemStack getStoredItemPrototype() {
            if (this.isMissing()) {
                return ItemStack.EMPTY;
            }
            return this.protoStack;
        }

        @Override
        @NotNull
        public IDrawer setStoredItem(@NotNull ItemStack itemPrototype) {
            return this.setStoredItem(itemPrototype, true);
        }

        protected IDrawer setStoredItem(@NotNull ItemStack itemPrototype, boolean notify) {
            if (this.isMissing()) {
                return this;
            }
            if (ItemStackHelper.isStackEncoded(itemPrototype)) {
                itemPrototype = ItemStackHelper.decodeItemStackPrototype(itemPrototype);
            }
            if (this.matcher.matches(itemPrototype)) {
                return this;
            }
            if ((itemPrototype = ItemStackHelper.getItemPrototype(itemPrototype)).isEmpty()) {
                this.reset(notify);
                return this;
            }
            this.protoStack = itemPrototype;
            this.protoStack.setCount(1);
            this.count = 0;
            IDrawerAttributes attrs = this.getAttributes();
            this.matcher = attrs.isDictConvertible() ? new ItemStackTagMatcher(this.protoStack) : new ItemStackMatcher(this.protoStack);
            this.group.syncSlots();
            if (notify) {
                this.onItemChanged();
            }
            return this;
        }

        protected IDrawer setStoredItemRaw(@NotNull ItemStack itemPrototype) {
            this.protoStack = itemPrototype = ItemStackHelper.getItemPrototype(itemPrototype);
            this.protoStack.setCount(1);
            this.count = 0;
            IDrawerAttributes attrs = this.getAttributes();
            this.matcher = attrs.isDictConvertible() ? new ItemStackTagMatcher(this.protoStack) : new ItemStackMatcher(this.protoStack);
            return this;
        }

        @Override
        public int getStoredItemCount() {
            if (this.isMissing() || this.protoStack.isEmpty()) {
                return 0;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            return this.count;
        }

        @Override
        public void setStoredItemCount(int amount) {
            this.setStoredItemCount(amount, true);
        }

        protected void setStoredItemCount(int amount, boolean notify) {
            if (this.isMissing() || this.protoStack.isEmpty() || this.count == amount) {
                return;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedVending()) {
                return;
            }
            this.count = Math.min(amount, this.getMaxCapacity());
            this.count = Math.max(this.count, 0);
            if (this.count == 0 && !attrs.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                this.reset(notify);
            } else if (notify) {
                this.onAmountChanged();
            }
        }

        protected void setStoredItemCountRaw(int amount) {
            this.count = amount;
        }

        @Override
        public int adjustStoredItemCount(int amount) {
            return this.adjustStoredItemCount(amount, true);
        }

        protected int adjustStoredItemCount(int amount, boolean notify) {
            if (this.isMissing() || this.protoStack.isEmpty() || amount == 0) {
                return Math.abs(amount);
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (amount > 0) {
                if (attrs.isUnlimitedVending()) {
                    return 0;
                }
                int originalCount = this.count;
                this.count = (long)this.count + (long)amount > Integer.MAX_VALUE ? this.getMaxCapacity() : Math.min(this.count + amount, this.getMaxCapacity());
                if (this.count != originalCount && notify) {
                    this.onAmountChanged();
                }
                if (attrs.isVoid()) {
                    return 0;
                }
                return amount - (this.count - originalCount);
            }
            if (attrs.isUnlimitedVending()) {
                return 0;
            }
            int originalCount = this.count;
            this.setStoredItemCount(originalCount + amount, notify);
            return -amount - (originalCount - this.count);
        }

        @Override
        public int getMaxCapacity(@NotNull ItemStack itemPrototype) {
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedStorage() || attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            if (itemPrototype.isEmpty()) {
                return 64 * this.getStackCapacity();
            }
            try {
                return Math.multiplyExact(DrawerData.getStackSize(itemPrototype), this.getStackCapacity());
            }
            catch (ArithmeticException e) {
                return Integer.MAX_VALUE;
            }
        }

        public static int getStackSize(@NotNull ItemStack itemPrototype) {
            if (itemPrototype.isEmpty()) {
                return 64;
            }
            return itemPrototype.getItem().getDefaultMaxStackSize();
        }

        @Override
        public int getAcceptingMaxCapacity(@NotNull ItemStack itemPrototype) {
            if (this.isMissing()) {
                return 0;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isVoid()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity(itemPrototype);
        }

        @Override
        public int getRemainingCapacity() {
            if (this.isMissing() || this.protoStack.isEmpty()) {
                return 0;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity() - this.getStoredItemCount();
        }

        @Override
        public int getAcceptingRemainingCapacity() {
            if (this.isMissing() || this.protoStack.isEmpty()) {
                return 0;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedVending() || attrs.isVoid()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity() - this.getStoredItemCount();
        }

        @Override
        public boolean canItemBeStored(@NotNull ItemStack itemPrototype, Predicate<ItemStack> matchPredicate) {
            if (this.isMissing()) {
                return false;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (this.protoStack.isEmpty() && !attrs.isItemLocked(LockAttribute.LOCK_EMPTY)) {
                return true;
            }
            if (matchPredicate == null) {
                return this.matcher.matches(itemPrototype);
            }
            return matchPredicate.test(this.protoStack);
        }

        @Override
        public boolean canItemBeExtracted(@NotNull ItemStack itemPrototype, Predicate<ItemStack> matchPredicate) {
            if (this.isMissing() || this.protoStack.isEmpty()) {
                return false;
            }
            if (matchPredicate == null) {
                return this.matcher.matches(itemPrototype);
            }
            return matchPredicate.test(this.protoStack);
        }

        @Override
        public boolean isEmpty() {
            return this.isMissing() || this.protoStack.isEmpty();
        }

        protected void reset(boolean notify) {
            this.protoStack = ItemStack.EMPTY;
            this.count = 0;
            this.matcher = ItemStackMatcher.EMPTY;
            this.group.syncSlots();
            if (notify) {
                this.onItemChanged();
            }
        }

        public void serializeNBT(ValueOutput output) {
            output.putBoolean("Missing", this.missing);
            if (this.protoStack.isEmpty()) {
                return;
            }
            output.store("Item", ItemStack.CODEC, (Object)this.protoStack);
            output.putInt("Count", this.count);
        }

        public void deserializeNBT(ValueInput input) {
            this.setStoredItemRaw(input.read("Item", ItemStack.CODEC).orElse(ItemStack.EMPTY));
            this.setStoredItemCountRaw(input.getIntOr("Count", 0));
            this.missing = input.getBooleanOr("Missing", false);
        }

        public void syncAttributes() {
            if (!this.protoStack.isEmpty()) {
                this.matcher = new ItemStackMatcher(this.protoStack);
            }
        }

        protected int getStackCapacity() {
            return 0;
        }

        protected void onItemChanged() {
        }

        protected void onAmountChanged() {
        }

        @Override
        public boolean canDetach() {
            return true;
        }

        @Override
        public boolean isMissing() {
            return this.missing;
        }

        @Override
        public void setDetached(boolean state) {
            if (this.missing != state) {
                if (state) {
                    this.setStoredItem(ItemStack.EMPTY);
                }
                this.missing = state;
                this.onItemChanged();
                this.onAmountChanged();
            }
        }

        @Override
        public IDrawer copy() {
            return new DrawerData(this);
        }
    }
}

