/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlockEntity;
import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IControlGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesGroupControl;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.FramedModelProperties;
import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.RenderDataProvider;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.ControllerData;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.texelsaurus.minecraft.chameleon.capabilities.ChameleonCapability;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityControllerIO
extends BaseBlockEntity
implements IDrawerGroup,
IControlGroup,
IFramedBlockEntity,
RenderDataProvider {
    private static final int[] drawerSlots = new int[]{0};
    public final ControllerData controllerData = new ControllerData();
    public final MaterialData materialData = new MaterialData();
    private final ItemRepositoryProxy itemRepository = new ItemRepositoryProxy();

    public BlockEntityControllerIO(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.injectData(this.controllerData);
        this.injectPortableData(this.materialData);
    }

    public BlockEntityControllerIO(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.CONTROLLER_IO.get(), pos, state);
    }

    @Override
    public IDrawerGroup getDrawerGroup() {
        BlockEntityController controller = this.getController();
        if (controller == null || !controller.isValidIO(this.getBlockPos())) {
            return null;
        }
        return controller.getDrawerGroup();
    }

    @Override
    public IDrawerAttributesGroupControl getGroupControllableAttributes(Player player) {
        BlockEntityController controller = this.getController();
        if (controller == null || !controller.isValidIO(this.getBlockPos())) {
            return null;
        }
        return controller.getGroupControllableAttributes(player);
    }

    @Override
    public IControlGroup getBoundControlGroup() {
        BlockEntityController controller = this.getController();
        if (controller == null || !controller.isValidIO(this.getBlockPos())) {
            return null;
        }
        return controller;
    }

    @Override
    public List<INetworked> getBoundRemoteNodes() {
        return List.of();
    }

    @Override
    public void validateRemoteNode(INetworked node) {
    }

    @Override
    public void invalidateRemoteNode(INetworked node) {
    }

    @Override
    public boolean addRemoteNode(INetworked node) {
        return false;
    }

    @Override
    public boolean isGroupValid() {
        return !this.isRemoved();
    }

    public void bindController(BlockPos coord) {
        if (this.controllerData.bindCoord(coord)) {
            this.setChanged();
        }
    }

    public BlockPos getControllerPos() {
        return this.controllerData.getCoord();
    }

    public BlockEntityController getController() {
        return this.controllerData.getController(this);
    }

    public IItemRepository getItemRepository() {
        return this.itemRepository;
    }

    @Override
    public int[] getAccessibleDrawerSlots() {
        BlockEntityController controller = this.getController();
        if (controller == null || !controller.isValidIO(this.getBlockPos())) {
            return drawerSlots;
        }
        return controller.getAccessibleDrawerSlots();
    }

    @Override
    public int getDrawerCount() {
        BlockEntityController controller = this.getController();
        if (controller == null || !controller.isValidIO(this.getBlockPos())) {
            return 0;
        }
        return controller.getDrawerCount();
    }

    @Override
    @NotNull
    public IDrawer getDrawer(int slot) {
        BlockEntityController controller = this.getController();
        if (controller == null || !controller.isValidIO(this.getBlockPos())) {
            return Drawers.DISABLED;
        }
        return controller.getDrawer(slot);
    }

    public void setChanged() {
        BlockEntityController controller = this.getController();
        if (controller != null && controller.isValidIO(this.getBlockPos())) {
            controller.setChanged();
        }
        super.setChanged();
    }

    @Override
    public <T> T getCapability(ChameleonCapability<T> capability) {
        if (capability == null || this.level == null) {
            return null;
        }
        return capability.getCapability(this.level, this.getBlockPos());
    }

    @Override
    public MaterialData material() {
        return this.materialData;
    }

    @Override
    @Nullable
    public Object getRenderData() {
        return FramedModelProperties.getModelData(this);
    }

    private class ItemRepositoryProxy
    implements IItemRepository {
        private ItemRepositoryProxy() {
        }

        @Override
        @NotNull
        public NonNullList<IItemRepository.ItemRecord> getAllItems() {
            BlockEntityController controller = BlockEntityControllerIO.this.getController();
            if (controller == null || !controller.isValidIO(BlockEntityControllerIO.this.getBlockPos())) {
                return NonNullList.create();
            }
            return controller.getItemRepository().getAllItems();
        }

        @Override
        @NotNull
        public ItemStack insertItem(@NotNull ItemStack stack, boolean simulate, Predicate<ItemStack> predicate) {
            BlockEntityController controller = BlockEntityControllerIO.this.getController();
            if (controller == null || !controller.isValidIO(BlockEntityControllerIO.this.getBlockPos())) {
                return stack;
            }
            return controller.getItemRepository().insertItem(stack, simulate, predicate);
        }

        @Override
        @NotNull
        public ItemStack extractItem(@NotNull ItemStack stack, int amount, boolean simulate, Predicate<ItemStack> predicate) {
            BlockEntityController controller = BlockEntityControllerIO.this.getController();
            if (controller == null || !controller.isValidIO(BlockEntityControllerIO.this.getBlockPos())) {
                return ItemStack.EMPTY;
            }
            return controller.getItemRepository().extractItem(stack, amount, simulate, predicate);
        }

        @Override
        public int getStoredItemCount(@NotNull ItemStack stack, Predicate<ItemStack> predicate) {
            BlockEntityController controller = BlockEntityControllerIO.this.getController();
            if (controller == null || !controller.isValidIO(BlockEntityControllerIO.this.getBlockPos())) {
                return 0;
            }
            return controller.getItemRepository().getStoredItemCount(stack, predicate);
        }

        @Override
        public int getRemainingItemCapacity(@NotNull ItemStack stack, Predicate<ItemStack> predicate) {
            BlockEntityController controller = BlockEntityControllerIO.this.getController();
            if (controller == null || !controller.isValidIO(BlockEntityControllerIO.this.getBlockPos())) {
                return 0;
            }
            return controller.getItemRepository().getRemainingItemCapacity(stack, predicate);
        }

        @Override
        public int getItemCapacity(@NotNull ItemStack stack, Predicate<ItemStack> predicate) {
            BlockEntityController controller = BlockEntityControllerIO.this.getController();
            if (controller == null || !controller.isValidIO(BlockEntityControllerIO.this.getBlockPos())) {
                return 0;
            }
            return controller.getItemRepository().getItemCapacity(stack, predicate);
        }
    }
}

