/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import com.jaquadro.minecraft.storagedrawers.block.BlockControllerIO;
import com.jaquadro.minecraft.storagedrawers.block.KeyType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockKeyButton
extends FaceAttachedHorizontalDirectionalBlock {
    public static final MapCodec<BlockKeyButton> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)KeyType.CODEC.fieldOf("key_type").forGetter(block -> block.keyType), (App)BlockKeyButton.propertiesCodec()).apply((Applicative)inst, BlockKeyButton::new));
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    protected static final VoxelShape CEILING_AABB_X = Block.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape CEILING_AABB_Z = Block.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape FLOOR_AABB_X = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0);
    protected static final VoxelShape FLOOR_AABB_Z = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0);
    protected static final VoxelShape NORTH_AABB = Block.box((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)2.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)14.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)3.0, (double)3.0, (double)2.0, (double)13.0, (double)13.0);
    protected static final VoxelShape PRESSED_CEILING_AABB_X = Block.box((double)3.0, (double)15.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape PRESSED_CEILING_AABB_Z = Block.box((double)3.0, (double)15.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape PRESSED_FLOOR_AABB_X = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    protected static final VoxelShape PRESSED_FLOOR_AABB_Z = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    protected static final VoxelShape PRESSED_NORTH_AABB = Block.box((double)3.0, (double)3.0, (double)15.0, (double)13.0, (double)13.0, (double)16.0);
    protected static final VoxelShape PRESSED_SOUTH_AABB = Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)1.0);
    protected static final VoxelShape PRESSED_WEST_AABB = Block.box((double)15.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    protected static final VoxelShape PRESSED_EAST_AABB = Block.box((double)0.0, (double)3.0, (double)3.0, (double)1.0, (double)13.0, (double)13.0);
    private final KeyType keyType;

    public BlockKeyButton(KeyType keyType, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACE, (Comparable)AttachFace.WALL));
        this.keyType = keyType;
    }

    public MapCodec<BlockKeyButton> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collision) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        boolean powered = (Boolean)state.getValue((Property)POWERED);
        switch ((AttachFace)state.getValue((Property)FACE)) {
            case FLOOR: {
                if (dir.getAxis() == Direction.Axis.X) {
                    return powered ? PRESSED_FLOOR_AABB_X : FLOOR_AABB_X;
                }
                return powered ? PRESSED_FLOOR_AABB_Z : FLOOR_AABB_Z;
            }
            case WALL: {
                return switch (dir) {
                    default -> throw new MatchException(null, null);
                    case Direction.EAST -> {
                        if (powered) {
                            yield PRESSED_EAST_AABB;
                        }
                        yield EAST_AABB;
                    }
                    case Direction.WEST -> {
                        if (powered) {
                            yield PRESSED_WEST_AABB;
                        }
                        yield WEST_AABB;
                    }
                    case Direction.SOUTH -> {
                        if (powered) {
                            yield PRESSED_SOUTH_AABB;
                        }
                        yield SOUTH_AABB;
                    }
                    case Direction.NORTH, Direction.UP, Direction.DOWN -> powered ? PRESSED_NORTH_AABB : NORTH_AABB;
                };
            }
        }
        if (dir.getAxis() == Direction.Axis.X) {
            return powered ? PRESSED_CEILING_AABB_X : CEILING_AABB_X;
        }
        return powered ? PRESSED_CEILING_AABB_Z : CEILING_AABB_Z;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockControllerIO io;
        BlockController controller;
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            return InteractionResult.CONSUME;
        }
        this.press(state, level, pos);
        this.playSound(player, (LevelAccessor)level, pos, true);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_ACTIVATE, pos);
        BlockPos targetPos = pos.offset(((Direction)state.getValue((Property)FACING)).getOpposite().getUnitVec3i());
        if (state.getValue((Property)FACE) == AttachFace.FLOOR) {
            targetPos = pos.offset(Direction.DOWN.getUnitVec3i());
        } else if (state.getValue((Property)FACE) == AttachFace.CEILING) {
            targetPos = pos.offset(Direction.UP.getUnitVec3i());
        }
        Block target = level.getBlockState(targetPos).getBlock();
        if (target instanceof BlockController) {
            BlockController controller2 = (BlockController)target;
            controller2.toggle(level, targetPos, player, this.keyType);
        } else if (target instanceof BlockControllerIO && (controller = (io = (BlockControllerIO)target).getController(level, pos)) != null) {
            controller.toggle(level, targetPos, player, this.keyType);
        }
        return InteractionResult.SUCCESS;
    }

    public void press(BlockState state, Level level, BlockPos pos) {
        level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        this.updateNeighbours(state, level, pos);
        level.scheduleTick(pos, (Block)this, 10);
    }

    protected void playSound(@Nullable Player player, LevelAccessor level, BlockPos pos, boolean clickOn) {
        level.playSound((Entity)(clickOn ? player : null), pos, this.getSound(clickOn), SoundSource.BLOCKS);
    }

    protected SoundEvent getSound(boolean clickOn) {
        return clickOn ? BlockSetType.OAK.buttonClickOn() : BlockSetType.OAK.buttonClickOff();
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            this.checkPressed(state, (Level)level, pos);
        }
    }

    protected void checkPressed(BlockState state, Level level, BlockPos pos) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
            this.updateNeighbours(state, level, pos);
            this.playSound(null, (LevelAccessor)level, pos, false);
            level.gameEvent(null, (Holder)GameEvent.BLOCK_DEACTIVATE, pos);
        }
    }

    private void updateNeighbours(BlockState state, Level level, BlockPos pos) {
        level.updateNeighborsAt(pos, (Block)this);
        level.updateNeighborsAt(pos.relative(BlockKeyButton.getConnectedDirection((BlockState)state).getOpposite()), (Block)this);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED, FACE});
    }
}

