/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers;

import com.jaquadro.minecraft.storagedrawers.capabilities.PlatformCapabilities;
import com.jaquadro.minecraft.storagedrawers.client.ClientModBusSubscriber;
import com.jaquadro.minecraft.storagedrawers.config.CompTierRegistry;
import com.jaquadro.minecraft.storagedrawers.config.ModClientConfig;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.Api;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.core.ModContainers;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.ModNetworking;
import com.jaquadro.minecraft.storagedrawers.core.ModRecipes;
import com.jaquadro.minecraft.storagedrawers.network.PlayerBoolConfigMessage;
import com.texelsaurus.minecraft.chameleon.ChameleonServices;
import com.texelsaurus.minecraft.chameleon.registry.ForgeRegistryContext;
import com.texelsaurus.minecraft.chameleon.service.ChameleonConfig;
import com.texelsaurus.minecraft.chameleon.service.ForgeConfig;
import com.texelsaurus.minecraft.chameleon.service.ForgeNetworking;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="storagedrawers")
public class StorageDrawers {
    public static final String MOD_ID = "storagedrawers";
    public static final Api api = new Api();
    public static Logger log = LogManager.getLogger();

    public StorageDrawers(FMLJavaModLoadingContext loadingContext) {
        ModCommonConfig.INSTANCE.context().init(MOD_ID, ChameleonConfig.Type.COMMON);
        ModClientConfig.INSTANCE.context().init(MOD_ID, ChameleonConfig.Type.CLIENT);
        loadingContext.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)((ForgeConfig)ModCommonConfig.INSTANCE.context()).forgeSpec);
        loadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)((ForgeConfig)ModClientConfig.INSTANCE.context()).forgeSpec);
        BusGroup busGroup = loadingContext.getModBusGroup();
        EventBus commonBus = FMLCommonSetupEvent.getBus((BusGroup)busGroup);
        ForgeRegistryContext context = new ForgeRegistryContext(busGroup);
        ModBlocks.init(context);
        ModItems.init(context);
        ModBlockEntities.init(context);
        ModContainers.init(context);
        ModDataComponents.init(context);
        ModRecipes.init(context);
        FMLCommonSetupEvent.getBus((BusGroup)busGroup).addListener(this::setup);
        ModConfigEvent.Loading.getBus((BusGroup)busGroup).addListener(this::onModConfigEvent);
        RegisterEvent.getBus((BusGroup)busGroup).addListener(ModCreativeTabs::init);
        RegisterCapabilitiesEvent.getBus((BusGroup)busGroup).addListener(PlatformCapabilities::register);
        PlayerEvent.PlayerLoggedOutEvent.BUS.addListener(this::onPlayerDisconnect);
        EntityJoinLevelEvent.BUS.addListener(this::onEntityJoinWorldEvent);
        ForgeNetworking.init(ModNetworking.INSTANCE, context);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ClientModBusSubscriber::registerItemModels);
    }

    private void setup(FMLCommonSetupEvent event) {
        CompTierRegistry.INSTANCE.initialize();
        PlatformCapabilities.initHandlers();
    }

    private void onModConfigEvent(ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.COMMON) {
            ModCommonConfig.INSTANCE.setLoaded();
        }
        if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            ModClientConfig.INSTANCE.setLoaded();
        }
    }

    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
    }

    public void onEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        if (!event.getLevel().isClientSide() || !(event.getEntity() instanceof Player)) {
            return;
        }
        if (Minecraft.getInstance().player == null) {
            return;
        }
        UUID playerId = Minecraft.getInstance().player.getUUID();
        if (event.getEntity().getUUID() == playerId) {
            ChameleonServices.NETWORK.sendToServer(new PlayerBoolConfigMessage(playerId.toString(), "invertShift", (Boolean)ModClientConfig.INSTANCE.GENERAL.invertShift.get()));
            ChameleonServices.NETWORK.sendToServer(new PlayerBoolConfigMessage(playerId.toString(), "invertClick", (Boolean)ModClientConfig.INSTANCE.GENERAL.invertClick.get()));
        }
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

