/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.server;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.TagParser;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.TagValueOutput;
import org.apache.logging.log4j.Logger;

public class ItemConfigHelper {
    private Map<ItemStack, Integer> itemStackList = new HashMap<ItemStack, Integer>();

    public ItemConfigHelper(List<? extends String> items, Logger logger, RegistryAccess registryAccess) {
        for (String string : items) {
            try {
                CompoundTag nbt = TagParser.parseCompoundFully((String)string);
                Optional optionalItemStack = ItemStack.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)nbt).result();
                if (optionalItemStack.isPresent()) {
                    ItemStack itemStack = (ItemStack)((Pair)optionalItemStack.get()).getFirst();
                    int lightLevel = 15;
                    if (nbt.contains("lightLevel")) {
                        lightLevel = ((Short)nbt.getShort("lightLevel").get()).shortValue();
                        nbt.remove("lightLevel");
                    }
                    this.itemStackList.put(itemStack, lightLevel);
                    logger.info("item config parser identified itemstack {}", (Object)itemStack);
                    continue;
                }
                logger.error("item config parser could not create itemStack from {}", (Object)string);
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        logger.info("item config parser finished, item count: {}", (Object)this.itemStackList.size());
    }

    public static String fromItemStack(ItemStack itemStack, int lightLevel, RegistryAccess registryAccess) {
        TagValueOutput tagValueOutput = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)registryAccess);
        tagValueOutput.store(ItemStack.MAP_CODEC, (Object)itemStack);
        CompoundTag resultTag = tagValueOutput.buildResult();
        if (lightLevel > 0) {
            resultTag.putShort("lightLevel", (short)lightLevel);
        }
        resultTag.remove("count");
        resultTag.putBoolean("anyNbtMatch", true);
        return resultTag.toString();
    }

    public int getLightLevel(ItemStack stack, RegistryAccess registryAccess) {
        if (stack == null || stack.isEmpty()) {
            return 0;
        }
        for (Map.Entry<ItemStack, Integer> entry : this.itemStackList.entrySet()) {
            ItemStack is = entry.getKey();
            if (is.getItem() != stack.getItem() || !this.tagsMatchWithWildcard(is, stack, registryAccess)) continue;
            return entry.getValue();
        }
        return 0;
    }

    private boolean tagsMatchWithWildcard(ItemStack configuredStack, ItemStack ingameStack, RegistryAccess registryAccess) {
        TagValueOutput tagValueOutput = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)registryAccess);
        tagValueOutput.store(ItemStack.MAP_CODEC, (Object)ingameStack);
        CompoundTag resultTag = tagValueOutput.buildResult();
        if (resultTag.contains("anyNbtMatch")) {
            return true;
        }
        return ItemStack.isSameItem((ItemStack)configuredStack, (ItemStack)ingameStack);
    }
}

