/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.server;

import atomicstryker.dynamiclights.server.DynamicLights;
import atomicstryker.dynamiclights.server.IDynamicLightSource;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class DynamicLightSourceContainer {
    private final IDynamicLightSource lightSource;
    private final BlockPos.MutableBlockPos activeLightPos = new BlockPos.MutableBlockPos();
    private final BlockPos.MutableBlockPos curSourcePos = new BlockPos.MutableBlockPos();
    private final int yOffset;
    final int[][] candidatePositionOffsets = new int[][]{{0, 0, 0}, {0, 0, 1}, {0, 0, -1}, {1, 0, 0}, {-1, 0, 0}, {0, 1, 0}, {0, -1, 0}};

    public DynamicLightSourceContainer(IDynamicLightSource light) {
        this.lightSource = light;
        this.yOffset = (int)Math.floor(light.getAttachmentEntity().getEyeHeight());
    }

    public boolean onUpdate() {
        BlockPos nextPos;
        Entity ent = this.lightSource.getAttachmentEntity();
        if (!ent.isAlive()) {
            return true;
        }
        if (this.hasEntityMoved(ent) && (nextPos = this.findNewCurLightPos(ent.level())) != null && !nextPos.equals((Object)this.activeLightPos)) {
            this.removeLight(ent.level());
            this.addLight(ent.level(), nextPos, this.lightSource.getLightLevel());
        }
        return false;
    }

    public BlockPos getLightPos() {
        return this.activeLightPos;
    }

    public IDynamicLightSource getLightSource() {
        return this.lightSource;
    }

    private boolean hasEntityMoved(Entity ent) {
        BlockPos newPos = ent.blockPosition().offset(0, this.yOffset, 0);
        if (!newPos.equals((Object)this.curSourcePos)) {
            this.curSourcePos.set((Vec3i)newPos);
            return true;
        }
        return false;
    }

    public void removeLight(Level world) {
        Block previousBlock = world.getBlockState((BlockPos)this.activeLightPos).getBlock();
        for (Map.Entry<Block, Block> vanillaBlockToLitBlockEntry : DynamicLights.vanillaBlocksToLitBlocksMap.entrySet()) {
            if (!vanillaBlockToLitBlockEntry.getValue().equals(previousBlock)) continue;
            world.setBlock((BlockPos)this.activeLightPos, vanillaBlockToLitBlockEntry.getKey().defaultBlockState(), 3);
        }
    }

    private BlockPos findNewCurLightPos(Level world) {
        for (int[] offsetTriple : this.candidatePositionOffsets) {
            BlockPos posWithOffset = this.curSourcePos.offset(offsetTriple[0], offsetTriple[1], offsetTriple[2]);
            BlockState blockState = world.getBlockState(posWithOffset);
            Block currentBlock = blockState.getBlock();
            for (Map.Entry<Block, Block> vanillaBlockToLitBlockEntry : DynamicLights.vanillaBlocksToLitBlocksMap.entrySet()) {
                if (!currentBlock.equals(vanillaBlockToLitBlockEntry.getKey()) || currentBlock instanceof LiquidBlock && (Integer)blockState.getValue((Property)LiquidBlock.LEVEL) != 0) continue;
                return posWithOffset;
            }
        }
        return null;
    }

    private void addLight(Level world, BlockPos nextPos, int lightLevel) {
        BlockState blockState = world.getBlockState(nextPos);
        Block currentBlock = blockState.getBlock();
        for (Map.Entry<Block, Block> vanillaBlockToLitBlockEntry : DynamicLights.vanillaBlocksToLitBlocksMap.entrySet()) {
            if (!currentBlock.equals(vanillaBlockToLitBlockEntry.getKey())) continue;
            world.setBlock(nextPos, (BlockState)vanillaBlockToLitBlockEntry.getValue().defaultBlockState().setValue((Property)BlockStateProperties.POWER, (Comparable)Integer.valueOf(lightLevel)), 3);
            world.scheduleTick(nextPos, vanillaBlockToLitBlockEntry.getValue(), 150);
            this.activeLightPos.set((Vec3i)nextPos);
            break;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof DynamicLightSourceContainer) {
            DynamicLightSourceContainer other = (DynamicLightSourceContainer)o;
            return other.lightSource == this.lightSource;
        }
        return false;
    }

    public int hashCode() {
        return this.lightSource.getAttachmentEntity().hashCode();
    }
}

