/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item;

import de.markusbordihn.easymobfarm.config.MobCatcherConfig;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModRecipeManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final String LOG_PREFIX = "[Recipe Manager]";
    private static final String MOB_CAPTURE_PREFIX = "mob_catcher/";

    private ModRecipeManager() {
    }

    public static void register(MinecraftServer minecraftServer) {
        log.info("{} Mod Recipe Manager ...", (Object)"Register Easy Mob Farm");
        ArrayList recipes = new ArrayList(minecraftServer.getRecipeManager().getRecipes());
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.ENDURING_CAPTURE_NET_ENABLED, "enduring_capture_net");
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.IRONBOUND_CONTAINMENT_CAGE_ENABLED, "ironbound_containment_cage");
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.MYSTIC_BINDING_CRYSTAL_ENABLED, "mystic_binding_crystal");
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.VOID_BINDING_CHAIN_ENABLED, "void_binding_chain");
        if (minecraftServer.getRecipeManager().getRecipes().size() != recipes.size()) {
            log.info("Updating recipes with adjusted recipes ...");
            RecipeMap recipeMap = RecipeMap.create(recipes);
            ModRecipeManager.setRecipes(minecraftServer.getRecipeManager(), recipeMap);
            for (ServerPlayer player : minecraftServer.getPlayerList().getPlayers()) {
                log.info("{} Sync recipe to player {} ...", (Object)LOG_PREFIX, (Object)player.getName().getString());
                player.connection.send((Packet)new ClientboundUpdateRecipesPacket(minecraftServer.getRecipeManager().getSynchronizedItemProperties(), minecraftServer.getRecipeManager().getSynchronizedStonecutterRecipes()));
            }
            minecraftServer.getRecipeManager().getRecipes().forEach(recipeHolder -> log.debug("{} Loaded recipe: {}", (Object)LOG_PREFIX, (Object)recipeHolder.id()));
        }
    }

    private static void setRecipes(RecipeManager recipeManager, RecipeMap recipeMap) {
        String[] possibleFieldNames;
        for (String fieldName : possibleFieldNames = new String[]{"recipes", "f_346395_", "field_54638", "preparedRecipes"}) {
            try {
                Field recipesField = RecipeManager.class.getDeclaredField(fieldName);
                recipesField.setAccessible(true);
                recipesField.set(recipeManager, recipeMap);
                log.info("{} Updated recipe map using field '{}'!", (Object)LOG_PREFIX, (Object)fieldName);
                return;
            }
            catch (NoSuchFieldException e) {
                log.debug("{} Field '{}' not found, trying next...", (Object)LOG_PREFIX, (Object)fieldName);
            }
            catch (IllegalAccessException e) {
                log.error("{} Failed to set recipe map for field '{}'!", (Object)LOG_PREFIX, (Object)fieldName, (Object)e);
                return;
            }
        }
        log.error("{} Failed to update recipe map! No valid field names found.", (Object)LOG_PREFIX);
    }

    private static boolean removeRecipeIfDisabled(Collection<RecipeHolder<?>> recipes, boolean isEnabled, String itemId) {
        if (isEnabled) {
            return false;
        }
        String recipeLocation = "easy_mob_farm:mob_catcher/" + itemId;
        boolean removed = recipes.removeIf(recipeHolder -> recipeHolder.id().location().toString().equals(recipeLocation));
        if (removed) {
            log.info("{} Removed {} recipe ...", (Object)LOG_PREFIX, (Object)recipeLocation);
        } else {
            log.error("{} Failed to deactivate recipe {} !", (Object)LOG_PREFIX, (Object)recipeLocation);
        }
        return removed;
    }
}

