/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.gametest;

import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.block.ModBlocks;
import de.markusbordihn.easymobfarm.gametest.GameTestHelpers;
import de.markusbordihn.easymobfarm.gametest.MobFarmBlockItemTestHelper;
import de.markusbordihn.easymobfarm.item.ModBlockItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.gametest.GameTest;

public class RedstoneSignalTest {
    @GameTest(structure="easy_mob_farm:gametest.3x3x3")
    public void testRedstoneSignalWithLever(GameTestHelper helper) {
        BlockPos mobFarmPos = new BlockPos(0, 1, 0);
        BlockPos leverPos = mobFarmPos.west();
        MobFarmBlockItemTestHelper.useMobFarmBlockItem(helper, ((Item)ModBlockItems.ANIMAL_PLAINS_FARM.get()).asItem(), mobFarmPos);
        GameTestHelpers.assertTrue(helper, "Mob farm block should be placed.", helper.getBlockState(mobFarmPos).is((Block)ModBlocks.ANIMAL_PLAINS_FARM.get()));
        GameTestHelpers.assertFalse(helper, "Mob farm should not be powered by redstone signal.", (Boolean)helper.getBlockState(mobFarmPos).getValue((Property)MobFarmBlock.POWERED));
        helper.setBlock(leverPos, (BlockState)((BlockState)((BlockState)Blocks.LEVER.defaultBlockState().setValue((Property)LeverBlock.FACING, (Comparable)Direction.WEST)).setValue((Property)LeverBlock.FACE, (Comparable)AttachFace.WALL)).setValue((Property)LeverBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        GameTestHelpers.assertTrue(helper, "Lever should be placed.", helper.getBlockState(leverPos).is(Blocks.LEVER));
        helper.pullLever(leverPos);
        helper.runAfterDelay(1L, () -> {
            GameTestHelpers.assertTrue(helper, "Mob farm should be powered by redstone signal.", (Boolean)helper.getBlockState(mobFarmPos).getValue((Property)MobFarmBlock.POWERED));
            helper.succeed();
        });
    }

    @GameTest(structure="easy_mob_farm:gametest.3x3x3")
    public void testRedstoneSignalWithRedstoneBlock(GameTestHelper helper) {
        BlockPos mobFarmPos = new BlockPos(0, 1, 0);
        BlockPos redstoneBlockPos = mobFarmPos.west();
        MobFarmBlockItemTestHelper.useMobFarmBlockItem(helper, ((Item)ModBlockItems.ANIMAL_PLAINS_FARM.get()).asItem(), mobFarmPos);
        GameTestHelpers.assertTrue(helper, "Mob farm block should be placed.", helper.getBlockState(mobFarmPos).is((Block)ModBlocks.ANIMAL_PLAINS_FARM.get()));
        GameTestHelpers.assertFalse(helper, "Mob farm should not be powered by redstone signal.", (Boolean)helper.getBlockState(mobFarmPos).getValue((Property)MobFarmBlock.POWERED));
        helper.setBlock(redstoneBlockPos, Blocks.REDSTONE_BLOCK.defaultBlockState());
        GameTestHelpers.assertTrue(helper, "Redstone block should be placed.", helper.getBlockState(redstoneBlockPos).is(Blocks.REDSTONE_BLOCK));
        helper.runAfterDelay(1L, () -> {
            GameTestHelpers.assertTrue(helper, "Mob farm should be powered by redstone signal.", (Boolean)helper.getBlockState(mobFarmPos).getValue((Property)MobFarmBlock.POWERED));
            helper.succeed();
        });
    }
}

