/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import de.markusbordihn.easymobfarm.compat.CompatConstants;
import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.CatVariants;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.FrogVariants;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.npc.Villager;

public class MobVariantData {
    public static final String VARIANT_TAG = "Variant";
    public static final String LARGE_VARIANT = "large";
    public static final String MEDIUM_VARIANT = "medium";
    public static final String SMALL_VARIANT = "small";
    public static final String TINY_VARIANT = "tiny";

    private MobVariantData() {
    }

    public static String getVariant(EntityType<?> entityType) {
        return "";
    }

    public static String getVariant(LivingEntity livingEntity) {
        if (livingEntity instanceof Cat) {
            Cat cat = (Cat)livingEntity;
            return cat.getVariant().unwrapKey().orElse(CatVariants.BLACK).location().toString().replace("minecraft:", "");
        }
        if (livingEntity instanceof Villager) {
            Villager villager = (Villager)livingEntity;
            return villager.getVillagerData().profession().getRegisteredName();
        }
        if (livingEntity instanceof MagmaCube) {
            MagmaCube magmaCube = (MagmaCube)livingEntity;
            return MobVariantData.getSizeVariant(magmaCube.getSize());
        }
        if (livingEntity instanceof Slime) {
            Slime slime = (Slime)livingEntity;
            return MobVariantData.getSizeVariant(slime.getSize());
        }
        if (livingEntity instanceof Frog) {
            Frog frog = (Frog)livingEntity;
            String frogVariant = frog.getVariant().unwrapKey().orElse(FrogVariants.TEMPERATE).location().toString().replace("minecraft:", "");
            if (CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED) {
                frogVariant = frogVariant.replace("swampier_swamps:", "").replace("frog_", "").replace("_variant", "");
            }
            return frogVariant;
        }
        return "";
    }

    public static String getVariant(CompoundTag compoundTag) {
        if (compoundTag == null) {
            return "";
        }
        if (compoundTag.contains(VARIANT_TAG)) {
            return compoundTag.getString(VARIANT_TAG).orElse("");
        }
        if (compoundTag.contains(VARIANT_TAG.toLowerCase(Locale.ROOT))) {
            return compoundTag.getString(VARIANT_TAG.toLowerCase(Locale.ROOT)).orElse("");
        }
        return "";
    }

    public static String getSizeVariant(float size) {
        if (size <= 1.0f) {
            return TINY_VARIANT;
        }
        if (size <= 2.0f) {
            return SMALL_VARIANT;
        }
        if (size < 4.0f) {
            return MEDIUM_VARIANT;
        }
        if (size >= 4.0f) {
            return LARGE_VARIANT;
        }
        return "";
    }
}

