/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import de.markusbordihn.easymobfarm.data.capture.MobColor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerType;

public class MobColorData {
    public static final String COLOR_TAG = "Color";

    private MobColorData() {
    }

    public static MobColor getColor(EntityType<?> entityType) {
        return MobColor.NONE;
    }

    public static MobColor getColor(LivingEntity livingEntity) {
        if (livingEntity instanceof Sheep) {
            Sheep sheep = (Sheep)livingEntity;
            return MobColor.byDyeColor(sheep.getColor());
        }
        if (livingEntity instanceof Villager) {
            Villager villager = (Villager)livingEntity;
            return MobColor.byVillagerType((ResourceKey<VillagerType>)((ResourceKey)villager.getVillagerData().type().unwrapKey().orElse(null)));
        }
        return MobColor.NONE;
    }

    public static MobColor getColor(CompoundTag compoundTag) {
        if (compoundTag == null || !compoundTag.contains(COLOR_TAG)) {
            return MobColor.NONE;
        }
        return MobColor.byName(compoundTag.getString(COLOR_TAG).orElse(""));
    }
}

