/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.worldgen.feature.configurations.BOPTreeConfiguration;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;

public abstract class BOPTreeFeature<FC extends BOPTreeConfiguration>
extends TreeFeature {
    protected BOPTreeFeature(Codec<FC> codec) {
        super(codec);
    }

    public boolean placeLeaves(LevelAccessor level, BlockPos pos, FoliagePlacer.FoliageSetter leaves, FC config) {
        if (this.canReplace(level, pos)) {
            leaves.set(pos, ((BOPTreeConfiguration)((Object)config)).foliageProvider.getState(level.getRandom(), pos));
            return true;
        }
        return false;
    }

    public boolean placeAltLeaves(LevelAccessor level, BlockPos pos, FoliagePlacer.FoliageSetter leaves, FC config) {
        if (this.canReplace(level, pos)) {
            leaves.set(pos, ((BOPTreeConfiguration)((Object)config)).altFoliageProvider.getState(level.getRandom(), pos));
            return true;
        }
        return false;
    }

    public boolean placeLog(LevelAccessor world, BlockPos pos, BiConsumer<BlockPos, BlockState> logs, FC config) {
        return this.placeLog(world, pos, null, logs, config);
    }

    public boolean placeLog(LevelAccessor level, BlockPos pos, Direction.Axis axis, BiConsumer<BlockPos, BlockState> logs, FC config) {
        BlockState directedLog;
        Property logAxisProperty = this.getLogAxisProperty(level, pos, config);
        BlockState log = ((BOPTreeConfiguration)((Object)config)).trunkProvider.getState(level.getRandom(), pos);
        BlockState blockState = directedLog = axis != null && logAxisProperty != null ? (BlockState)log.setValue(logAxisProperty, (Comparable)axis) : log;
        if (this.canReplace(level, pos)) {
            logs.accept(pos, directedLog);
            return true;
        }
        return false;
    }

    public boolean setVine(LevelAccessor world, RandomSource rand, BlockPos pos, Direction side, int length, FC config) {
        BlockState vine = ((BOPTreeConfiguration)((Object)config)).vineProvider.getState(rand, pos);
        BlockState directedVine = vine.getBlock() instanceof VineBlock ? (BlockState)((BlockState)((BlockState)((BlockState)vine.setValue((Property)VineBlock.NORTH, (Comparable)Boolean.valueOf(side == Direction.NORTH))).setValue((Property)VineBlock.EAST, (Comparable)Boolean.valueOf(side == Direction.EAST))).setValue((Property)VineBlock.SOUTH, (Comparable)Boolean.valueOf(side == Direction.SOUTH))).setValue((Property)VineBlock.WEST, (Comparable)Boolean.valueOf(side == Direction.WEST)) : vine;
        boolean setOne = false;
        while (world.getBlockState(pos).isAir() && length > 0 && rand.nextInt(12) > 0) {
            this.setBlock((LevelWriter)world, pos, directedVine);
            setOne = true;
            --length;
            pos = pos.below();
        }
        return setOne;
    }

    public boolean setHanging(LevelAccessor level, BlockPos pos, FC config) {
        BlockState hanging = ((BOPTreeConfiguration)((Object)config)).hangingProvider.getState(level.getRandom(), pos);
        if (this.canReplace(level, pos)) {
            this.setBlock((LevelWriter)level, pos, hanging);
        }
        return false;
    }

    public boolean setTrunkFruit(LevelAccessor level, BlockPos pos, FC config) {
        BlockState trunkFruit = ((BOPTreeConfiguration)((Object)config)).trunkFruitProvider.getState(level.getRandom(), pos);
        if (trunkFruit == null) {
            return false;
        }
        if (this.canReplace(level, pos)) {
            this.setBlock((LevelWriter)level, pos, trunkFruit);
        }
        return false;
    }

    protected boolean canReplace(LevelAccessor level, BlockPos pos) {
        return TreeFeature.isAirOrLeaves((LevelSimulatedReader)level, (BlockPos)pos) || level.isStateAtPosition(pos, state -> {
            Block block = state.getBlock();
            return state.is(BlockTags.REPLACEABLE_BY_TREES) || state.is(BlockTags.SAPLINGS) || block == Blocks.VINE || block == BOPBlocks.WILLOW_VINE || block == BOPBlocks.DEAD_BRANCH || block == Blocks.MOSS_CARPET || block == BOPBlocks.SPANISH_MOSS || block instanceof BushBlock;
        });
    }

    protected Property getLogAxisProperty(LevelAccessor level, BlockPos pos, FC config) {
        BlockState log = ((BOPTreeConfiguration)((Object)config)).trunkProvider.getState(level.getRandom(), pos);
        for (Property property : log.getProperties()) {
            List allowedValues = property.getPossibleValues();
            if (!allowedValues.contains(Direction.Axis.X) || !allowedValues.contains(Direction.Axis.Y) || !allowedValues.contains(Direction.Axis.Z)) continue;
            return property;
        }
        return null;
    }

    public static boolean isFree(LevelSimulatedReader level, BlockPos pos) {
        return BOPTreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos) || level.isStateAtPosition(pos, state -> state.is(BlockTags.LOGS));
    }
}

