/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.util.SimpleBlockPredicate;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class GiantGlowshroomFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> world.getBlockState(pos).getBlock() == Blocks.GRASS_BLOCK || world.getBlockState(pos).getBlock() == Blocks.MYCELIUM || world.getBlockState(pos).getBlock() == Blocks.STONE || world.getBlockState(pos).getBlock() == Blocks.DEEPSLATE || world.getBlockState(pos).getBlock() == BOPBlocks.GLOWING_MOSS_BLOCK || world.getBlockState(pos).getBlock() == Blocks.MUD;
    protected SimpleBlockPredicate replace = (world, pos) -> TreeFeature.isAirOrLeaves((LevelSimulatedReader)world, (BlockPos)pos) || world.getBlockState(pos).getBlock() instanceof BushBlock || world.getBlockState(pos).getBlock() == BOPBlocks.GLOWING_MOSS_CARPET || world.getBlockState(pos).getBlock() == Blocks.MOSS_CARPET;

    public GiantGlowshroomFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        int z;
        int x;
        WorldGenLevel world = featurePlaceContext.level();
        ChunkGenerator chunkGenerator = featurePlaceContext.chunkGenerator();
        RandomSource rand = featurePlaceContext.random();
        BlockPos startPos = featurePlaceContext.origin();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.config();
        while (startPos.getY() >= world.getMinY() + 1 && this.replace.matches(world, startPos)) {
            startPos = startPos.below();
        }
        if (!this.placeOn.matches(world, startPos.offset(0, 0, 0))) {
            return false;
        }
        if (!this.checkSpace(world, startPos.above())) {
            return false;
        }
        BlockPos pos = startPos.above();
        int height = 15 + rand.nextInt(10);
        int radius = 3 + rand.nextInt(3);
        for (int y = 0; y < height; ++y) {
            this.setBlock(world, pos.above(y), Blocks.MUSHROOM_STEM.defaultBlockState());
        }
        for (x = -(radius - 1); x <= radius - 1; ++x) {
            for (z = -(radius - 1); z <= radius - 1; ++z) {
                this.setBlock(world, pos.offset(x, height, z), (BlockState)BOPBlocks.GLOWSHROOM_BLOCK.defaultBlockState().setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false)));
            }
        }
        for (x = -radius; x <= radius; ++x) {
            for (z = -radius; z <= radius; ++z) {
                if ((x == -radius || x == radius) && (z == -radius || z == radius)) continue;
                if (x == radius) {
                    this.setBlock(world, pos.offset(x, height - 1, z), (BlockState)BOPBlocks.GLOWSHROOM_BLOCK.defaultBlockState().setValue((Property)HugeMushroomBlock.WEST, (Comparable)Boolean.valueOf(false)));
                    this.setBlock(world, pos.offset(x, height - 2, z), (BlockState)BOPBlocks.GLOWSHROOM_BLOCK.defaultBlockState().setValue((Property)HugeMushroomBlock.WEST, (Comparable)Boolean.valueOf(false)));
                }
                if (x == -radius) {
                    this.setBlock(world, pos.offset(x, height - 1, z), (BlockState)BOPBlocks.GLOWSHROOM_BLOCK.defaultBlockState().setValue((Property)HugeMushroomBlock.EAST, (Comparable)Boolean.valueOf(false)));
                    this.setBlock(world, pos.offset(x, height - 2, z), (BlockState)BOPBlocks.GLOWSHROOM_BLOCK.defaultBlockState().setValue((Property)HugeMushroomBlock.EAST, (Comparable)Boolean.valueOf(false)));
                }
                if (z == radius) {
                    this.setBlock(world, pos.offset(x, height - 1, z), (BlockState)BOPBlocks.GLOWSHROOM_BLOCK.defaultBlockState().setValue((Property)HugeMushroomBlock.NORTH, (Comparable)Boolean.valueOf(false)));
                    this.setBlock(world, pos.offset(x, height - 2, z), (BlockState)BOPBlocks.GLOWSHROOM_BLOCK.defaultBlockState().setValue((Property)HugeMushroomBlock.NORTH, (Comparable)Boolean.valueOf(false)));
                }
                if (z != -radius) continue;
                this.setBlock(world, pos.offset(x, height - 1, z), (BlockState)BOPBlocks.GLOWSHROOM_BLOCK.defaultBlockState().setValue((Property)HugeMushroomBlock.SOUTH, (Comparable)Boolean.valueOf(false)));
                this.setBlock(world, pos.offset(x, height - 2, z), (BlockState)BOPBlocks.GLOWSHROOM_BLOCK.defaultBlockState().setValue((Property)HugeMushroomBlock.SOUTH, (Comparable)Boolean.valueOf(false)));
            }
        }
        return true;
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.setBlock((LevelWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean checkSpace(WorldGenLevel world, BlockPos pos) {
        for (int y = 0; y <= 25; ++y) {
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos pos1 = pos.offset(x, y, z);
                    if (pos1.getY() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

