/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.util.SimpleBlockPredicate;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class FallenJacarandaLogFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> world.getBlockState(pos).getBlock() == Blocks.GRASS_BLOCK || world.getBlockState(pos).getBlock() == Blocks.COARSE_DIRT;
    protected SimpleBlockPredicate replace = (world, pos) -> TreeFeature.isAirOrLeaves((LevelSimulatedReader)world, (BlockPos)pos) || world.getBlockState(pos).getBlock() instanceof BushBlock;

    public FallenJacarandaLogFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.level();
        ChunkGenerator chunkGenerator = featurePlaceContext.chunkGenerator();
        RandomSource rand = featurePlaceContext.random();
        BlockPos startPos = featurePlaceContext.origin();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.config();
        while (startPos.getY() >= world.getMinY() + 1 && this.replace.matches(world, startPos)) {
            startPos = startPos.below();
        }
        int length = 4 + rand.nextInt(2);
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(rand);
        int groundCheck = 0;
        boolean startConnected = false;
        boolean endConnected = false;
        int groundRequired = length % 2 == 0 ? length - 1 : length - 2;
        for (int i = 0; i < length; ++i) {
            if (!this.placeOn.matches(world, startPos.relative(direction, i))) continue;
            if (i <= 1) {
                startConnected = true;
            }
            if (i >= length - 2) {
                endConnected = true;
            }
            ++groundCheck;
        }
        if (groundCheck < groundRequired) {
            if (!startConnected) {
                return false;
            }
            if (!endConnected) {
                return false;
            }
        }
        if (!this.checkSpace(world, startPos.above(), direction, length)) {
            return false;
        }
        BlockPos pos = startPos.above();
        for (int i = 0; i < length; ++i) {
            BlockState blockBelow;
            this.setBlock(world, pos.relative(direction, i), (BlockState)BOPBlocks.JACARANDA_LOG.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis()));
            BlockState blockAbove = world.getBlockState(pos.above().relative(direction, i));
            if (blockAbove.isAir() || blockAbove.getBlock() instanceof BushBlock) {
                this.setBlock(world, pos.above().relative(direction, i), BOPBlocks.SPROUT.defaultBlockState());
            }
            if ((blockBelow = world.getBlockState(pos.below().relative(direction, i))).isAir() || blockBelow.getFluidState().is((Fluid)Fluids.WATER) || blockBelow.getBlock() instanceof BushBlock) {
                this.setBlock(world, pos.below().relative(direction, i), (BlockState)Blocks.HANGING_ROOTS.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(world.isWaterAt(pos.below().relative(direction, i)))));
            }
            if (!blockBelow.is(BlockTags.DIRT)) continue;
            super.setBlock((LevelWriter)world, pos.below().relative(direction, i), Blocks.ROOTED_DIRT.defaultBlockState());
        }
        return true;
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.setBlock((LevelWriter)world, pos, state);
            return true;
        }
        if (world.getBlockState(pos).getFluidState().is((Fluid)Fluids.WATER) && state.getBlock() == Blocks.HANGING_ROOTS) {
            super.setBlock((LevelWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean checkSpace(WorldGenLevel world, BlockPos pos, Direction direction, int length) {
        for (int y = 0; y <= 2; ++y) {
            for (int i = 0; i < length; ++i) {
                BlockPos pos1 = pos.above(y).relative(direction, i);
                if (pos1.getY() < 255 && this.replace.matches(world, pos1)) continue;
                return false;
            }
        }
        return true;
    }
}

